/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.common.model.ui.attribute.IAttributeContentProposalProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeTreeContentProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeSelectionContentAssistProvider
implements IAttributeContentProposalProvider {
    XModelObject object;
    XAttribute attribute;
    DefaultXAttributeTreeContentProvider treeProvider;

    @Override
    public boolean isRelevant(XModelObject object, XAttribute attribute) {
        if (object == null) {
            return false;
        }
        String editor = attribute.getEditor().getName();
        return editor != null && editor.startsWith("Tree");
    }

    void addAttributeValueProposals(List<IContentProposal> proposalsList, String text, int offset) {
        if (this.treeProvider == null) {
            return;
        }
        XFilteredTree tree = this.treeProvider.getFilteredTree();
        if (tree == null) {
            this.treeProvider.getElements(null);
            tree = this.treeProvider.getFilteredTree();
        }
        if (tree == null) {
            return;
        }
        XModelObject root = tree.getRoot();
        if (root == null) {
            return;
        }
        String startText = text.substring(0, offset);
        TreeMap<String, Object> pathsMap = new TreeMap<String, Image>();
        this.collectPaths(startText, root, tree, pathsMap);
        String[] paths = pathsMap.keySet().toArray(new String[0]);
        if (paths.length == 1 && text.startsWith(paths[0])) {
            pathsMap = new TreeMap();
            this.collectPaths(paths[0], root, tree, pathsMap);
            paths = pathsMap.keySet().toArray(new String[0]);
        }
        int i = 0;
        while (i < paths.length) {
            String cfr_ignored_0 = paths[i];
            String replacementString = paths[i];
            text.startsWith(replacementString);
            IContentProposal proposal = AttributeContentProposalProviderFactory.makeContentProposal(replacementString, replacementString, null);
            proposalsList.add(proposal);
            ++i;
        }
    }

    void collectPaths(String startText, XModelObject object, XFilteredTree tree, Map<String, Image> map) {
        String value = tree.getValue(object);
        if (value != null && value.startsWith(startText)) {
            if (!(value.length() <= 0 || value.equals(startText) && value.endsWith("/"))) {
                map.put(value, EclipseResourceUtil.getImage((XModelObject)object));
            }
            if (value.length() > startText.length()) {
                return;
            }
        } else if (value != null && !startText.startsWith(value)) {
            return;
        }
        XModelObject[] cs = tree.getChildren(object);
        int i = 0;
        while (i < cs.length) {
            this.collectPaths(startText, cs[i], tree, map);
            ++i;
        }
    }

    @Override
    public IContentProposalProvider getContentProposalProvider() {
        return new ContentProposalProvider();
    }

    @Override
    public int getProposalAcceptanceStyle() {
        return 2;
    }

    @Override
    public void init(XModelObject object, XEntityData data, XAttribute attribute) {
        this.object = object;
        this.attribute = attribute;
        this.treeProvider = new DefaultXAttributeTreeContentProvider(attribute, object.getModel(), object);
    }

    @Override
    public LabelProvider getCustomLabelProbider() {
        return null;
    }

    @Override
    public void dispose() {
        this.object = null;
        this.attribute = null;
        this.treeProvider = null;
    }

    class ContentProposalProvider
    implements IContentProposalProvider {
        ContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<IContentProposal> proposalsList = new ArrayList<IContentProposal>();
            DefaultTreeSelectionContentAssistProvider.this.addAttributeValueProposals(proposalsList, contents, position);
            return proposalsList.toArray(new IContentProposal[0]);
        }
    }
}

