/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorDialog;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.xpl.SelectableFormLabel;

public class HyperlinkStringButtonFieldEditor
extends StringButtonFieldEditor
implements IFieldEditor,
IPropertyChangeListener,
PropertyChangeListener,
IPropertyFieldEditor {
    protected PropertyEditorDialog editorDialog;
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected IValueChangeListener valueChangeListener;
    protected Composite composite;
    private Label label;
    private IActionProvider actionProvider;
    private IAction labelAction;

    public HyperlinkStringButtonFieldEditor() {
    }

    public HyperlinkStringButtonFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    protected Label getHyperlinkLabelControl() {
        return this.label;
    }

    public Label getHyperlinkLabelControl(Composite parent) {
        if (this.label == null) {
            Font font;
            Color fg;
            if (this.labelAction != null) {
                int style = this.getSettings().getStyle("Hyperlink.Style");
                if (style == -1) {
                    style = 0;
                }
                parent.getBackground();
                fg = this.getSettings().getColor("Hyperlink.Foreground");
                font = this.getSettings().getFont("Hyperlink.Font");
                this.label = new SelectableFormLabel(parent, style);
                ((SelectableFormLabel)this.label).addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        HyperlinkStringButtonFieldEditor.this.labelAction.run();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            } else {
                int style = this.getSettings().getStyle("Label.Style");
                parent.getBackground();
                fg = this.getSettings().getColor("Label.Foreground");
                font = this.getSettings().getFont("Label.Font");
                this.label = new Label(parent, style);
            }
            this.label.setFont(font);
            this.label.setForeground(fg);
            this.label.setEnabled(this.isEnabled());
            String text = this.getLabelText();
            if (text != null) {
                this.label.setText(text);
            }
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    HyperlinkStringButtonFieldEditor.this.label = null;
                }
            });
        } else {
            this.checkParent((Control)this.label, parent);
        }
        return this.label;
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
        this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
        this.actionProvider = (IActionProvider)propertyEditor.getAdapter(IActionProvider.class);
        if (this.actionProvider != null) {
            this.labelAction = this.actionProvider.getAction("LABEL_ACTION");
        }
        this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
    }

    protected String changePressed() {
        this.editorDialog = new PropertyEditorDialog(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), this.propertyEditor);
        int i = this.editorDialog.open();
        return i != 0 ? null : this.valueProvider.getStringValue(false);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Composite control = this.getTextChangeControl(parent);
        control.setLayoutData((Object)new GridData(768));
    }

    protected Composite getTextChangeControl(Composite parent) {
        this.createTextChangeControl(parent);
        return this.composite;
    }

    protected Control createTextChangeControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackgroundMode(1);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        Control textControl = this.createTextControl(this.composite);
        GridData gd = new GridData(768);
        textControl.setLayoutData((Object)gd);
        Label control = new Label(this.composite, 0);
        gd = new GridData();
        gd.widthHint = 5;
        control.setLayoutData((Object)gd);
        control = this.getChangeControl(this.composite);
        gd = new GridData();
        gd.widthHint = this.convertHorizontalDLUsToPixels((Control)control, 61);
        gd.heightHint = textControl.computeSize((int)-1, (int)-1).y;
        control.setLayoutData((Object)gd);
        return this.composite;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.valueChangeListener != null && "field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            Object v = evt.getNewValue();
            this.valueProvider.removeValueChangeListener(this);
            this.setStringValue(v == null ? "" : v.toString());
            this.valueProvider.addValueChangeListener(this);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        Control[] controls = this.getControls(parent);
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                Control[] compositeChildren = ((Composite)controls[i]).getChildren();
                int j = 0;
                while (j < compositeChildren.length) {
                    compositeChildren[j++].setEnabled(enabled);
                }
            }
            controls[i].setEnabled(enabled);
            ++i;
        }
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setEnabled(enabled);
        }
    }

    public Control[] getControls(Composite parent) {
        return new Control[]{this.getHyperlinkLabelControl(parent), this.getTextChangeControl(parent)};
    }
}

