/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.util.HashMap;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposalFactory;
import org.jboss.tools.common.model.ui.editors.dnd.PlainTextDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.UnknownDropCommand;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class DropCommandFactory {
    private static final DropCommandFactory INSTANCE = new DropCommandFactory();
    public static final IDropCommand PLAIN_MIME_COMMAND = new PlainTextDropCommand();
    public static final IDropCommand UNKNOWN_MIME_COMMAND = new UnknownDropCommand();
    public static final String UNKNOWN_MIME_TYPE = "exadel/unknown";
    public static final HashMap<String, String> fMimeCommandMap = new HashMap();
    public static final String kFileMime = "application/x-moz-file";
    public static final String kURLMime = "text/x-moz-url";
    public static final String kUnicodeMime = "text/unicode";
    public static final String kHtmlText = "text/html";
    static String PACKAGE = "org.jboss.tools.common.model.ui.editors.dnd.";
    static String UNKNOWN_DROP_COMMAND = "org.jboss.tools.common.model.ui.editors.dnd.UnknownDropCommand";
    static String TEXT_DROP_COMMAND = "org.jboss.tools.common.model.ui.editors.dnd.PlainTextDropCommand";
    static String FILE_DROP_COMMAND = "org.jboss.tools.jst.jsp.jspeditor.dnd.FileDropCommand";
    static String PALETTE_DROP_COMMAND = "org.jboss.tools.jst.jsp.jspeditor.dnd.PaletteDropCommand";

    static {
        fMimeCommandMap.put(kFileMime, FILE_DROP_COMMAND);
        fMimeCommandMap.put(kURLMime, FILE_DROP_COMMAND);
        fMimeCommandMap.put("vpe/model", PALETTE_DROP_COMMAND);
        fMimeCommandMap.put("text/plain", TEXT_DROP_COMMAND);
        fMimeCommandMap.put(kUnicodeMime, TEXT_DROP_COMMAND);
        fMimeCommandMap.put(kHtmlText, TEXT_DROP_COMMAND);
        fMimeCommandMap.put(UNKNOWN_MIME_TYPE, UNKNOWN_DROP_COMMAND);
    }

    public static DropCommandFactory getInstance() {
        return INSTANCE;
    }

    public IDropCommand getDropCommand(String mimeType, ITagProposalFactory tagProposalFactory) {
        IDropCommand fInstance = UNKNOWN_MIME_COMMAND;
        String fClassName = fMimeCommandMap.get(mimeType);
        fInstance = (IDropCommand)ModelFeatureFactory.getInstance().createFeatureInstance(fClassName);
        if (fInstance == null) {
            fInstance = new UnknownDropCommand();
        }
        if (fInstance != null) {
            fInstance.setTagProposalFactory(tagProposalFactory);
        }
        return fInstance;
    }
}

