/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.objecteditor;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.adapter.AdapterFactory;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorFactory;
import org.jboss.tools.common.model.ui.objecteditor.XAttributeInfo;

public class XCellEditor
extends CellEditor
implements ICellEditorListener {
    XAttributeInfo info;
    CellEditor childEditor;
    PropertyEditor propertyEditor;
    Composite parent;
    ListenerList listeners = new ListenerList();

    public XCellEditor(Composite parent) {
        this.parent = parent;
    }

    protected Control createControl(Composite parent) {
        this.parent = parent;
        return null;
    }

    protected Object doGetValue() {
        if (this.childEditor == null) {
            return this.info;
        }
        this.info.setValue((String)this.childEditor.getValue());
        this.info.propertyEditor = this.propertyEditor;
        return this.info;
    }

    protected void doSetFocus() {
        if (this.childEditor == null) {
            return;
        }
        this.childEditor.setFocus();
    }

    protected void doSetValue(Object value) {
        if (this.childEditor != null && this.childEditor.getControl() != null && !this.childEditor.getControl().isDisposed()) {
            this.childEditor.removeListener((ICellEditorListener)this);
            this.childEditor.dispose();
        }
        this.info = (XAttributeInfo)value;
        XAttribute attribute = this.info.getObject().getModelEntity().getAttribute(this.info.getName());
        XModelObject modelObject = this.info.getObject();
        XModel model = this.info.getObject().getModel();
        IModelPropertyEditorAdapter adapter = AdapterFactory.getAdapter(attribute, modelObject, model);
        this.propertyEditor = PropertyEditorFactory.createPropertyEditor((Object)adapter, attribute, modelObject);
        this.childEditor = this.propertyEditor.getCellEditor(this.parent);
        this.childEditor.addListener((ICellEditorListener)this);
        this.setValueValid(true);
    }

    public Control getControl() {
        if (this.childEditor == null) {
            return null;
        }
        return this.childEditor.getControl();
    }

    public CellEditor.LayoutData getLayoutData() {
        if (this.childEditor == null) {
            return null;
        }
        return this.childEditor.getLayoutData();
    }

    public void create(Composite parent) {
        this.parent = parent;
        if (this.childEditor == null) {
            return;
        }
        this.childEditor.create(parent);
    }

    public void activate() {
        if (this.childEditor == null) {
            return;
        }
        this.childEditor.activate();
    }

    public void dispose() {
        if (this.childEditor == null) {
            return;
        }
        this.childEditor.dispose();
    }

    public void deactivate() {
        if (this.childEditor == null) {
            return;
        }
        this.propertyEditor.fireValueChanged();
        this.childEditor.deactivate();
    }

    public void addListener(ICellEditorListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ICellEditorListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void applyEditorValue() {
        Object[] list = this.listeners.getListeners();
        if (list != null && list.length > 0) {
            int i = 0;
            while (i < list.length) {
                ((ICellEditorListener)list[i]).applyEditorValue();
                ++i;
            }
        }
    }

    public void cancelEditor() {
        Object[] list = this.listeners.getListeners();
        if (list != null && list.length > 0) {
            int i = 0;
            while (i < list.length) {
                ((ICellEditorListener)list[i]).cancelEditor();
                ++i;
            }
        }
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        Object[] list = this.listeners.getListeners();
        if (list != null && list.length > 0) {
            int i = 0;
            while (i < list.length) {
                ((ICellEditorListener)list[i]).editorValueChanged(oldValidState, newValidState);
                ++i;
            }
        }
    }
}

