/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.outline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectCache;

public class XModelObjectContentProvider
extends WorkbenchContentProvider {
    XFilteredTreeConstraint[] filters = null;
    XModelObjectCache cache;
    private Viewer viewer = null;

    public void setRoot(XModelObjectCache cache) {
        if (this.isEqualObject(cache)) {
            return;
        }
        this.cache = cache;
        if (this.viewer != null) {
            this.viewer.refresh();
            ((TreeViewer)this.viewer).expandToLevel(2);
            if (cache != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)cache.getObject()));
            }
        }
    }

    private boolean isEqualObject(XModelObjectCache cache) {
        if (this.cache == null && cache == null) {
            return true;
        }
        if (this.cache == null || cache == null) {
            return false;
        }
        return this.cache.getObject() == cache.getObject();
    }

    public void addFilter(XFilteredTreeConstraint filter) {
        if (this.filters == null) {
            this.filters = new XFilteredTreeConstraint[]{filter};
        } else {
            XFilteredTreeConstraint[] fs = new XFilteredTreeConstraint[this.filters.length + 1];
            System.arraycopy(this.filters, 0, fs, 0, this.filters.length);
            fs[this.filters.length] = filter;
            this.filters = fs;
        }
    }

    public Object[] getChildren(Object element) {
        if (!(element instanceof XModelObject)) {
            return new XModelObject[0];
        }
        XModelObject o = (XModelObject)element;
        Object[] os = o.getChildren();
        if (this.filters == null || os.length == 0) {
            return os;
        }
        if (this.isHidingAllChildren(o)) {
            return new XModelObject[0];
        }
        if (!this.isHidingSomeChildren(o)) {
            return os;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        int i = 0;
        while (i < os.length) {
            if (this.accepts((XModelObject)os[i])) {
                l.add(os[i]);
            }
            ++i;
        }
        return l.toArray(new XModelObject[0]);
    }

    public Object[] getElements(Object element) {
        Object[] objectArray;
        XModelObject o;
        XModelObject xModelObject = o = this.cache == null ? null : this.cache.getObject();
        if (o == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = o;
        }
        return objectArray;
    }

    public Object getParent(Object element) {
        if (!(element instanceof XModelObject)) {
            return null;
        }
        XModelObject o = (XModelObject)element;
        return o.getParent();
    }

    private boolean isHidingAllChildren(XModelObject o) {
        if (this.filters == null) {
            return false;
        }
        int i = 0;
        while (i < this.filters.length) {
            if (this.filters[i].isHidingAllChildren(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isHidingSomeChildren(XModelObject o) {
        if (this.filters == null) {
            return false;
        }
        int i = 0;
        while (i < this.filters.length) {
            if (this.filters[i].isHidingSomeChildren(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean accepts(XModelObject o) {
        if (this.filters == null) {
            return true;
        }
        int i = 0;
        while (i < this.filters.length) {
            if (this.filters[i].accepts(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer;
        if (viewer instanceof TreeViewer) {
            ((TreeViewer)viewer).setAutoExpandLevel(2);
        }
        if (viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed()) {
            return;
        }
        viewer.refresh();
        if ((viewer.getSelection() == null || viewer.getSelection().isEmpty()) && this.cache != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)this.cache.getObject()));
        }
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
        this.filters = null;
    }
}

