/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.reporting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.messages.UIMessages;
import org.jboss.tools.common.model.ui.reporting.ReportPreference;
import org.jboss.tools.common.model.ui.widgets.ReferenceListener;
import org.jboss.tools.common.model.ui.widgets.TextAndReferenceComponent;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.reporting.ProblemReportingHelper;

class ReportProblemWizardView
extends AbstractQueryWizardView {
    private static final SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat CURENT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat SESSION_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final long TWENTY_FOUR_HOURS = 86400000L;
    private Text logFileName;
    private Button browseButton;
    private static final int LINE_LIMIT = 70;
    int stackTracesCount;
    Text problemDescription;
    XAttributeSupport sendSupport;
    XAttributeSupport infoSupport;
    XModelObject reportOptions = PreferenceModelUtilities.getPreferenceModel().getByPath("%Options%/Struts Studio/Report Problem");
    XModelObject exceptionsObject = PreferenceModelUtilities.getPreferenceModel().createModelObject("ProblemBufferEditor", null);
    XEntityData sendData = XEntityDataImpl.create((String[][])new String[][]{{"SharableReportProblem"}, {"attachRedHatLog", "no"}});
    XEntityData sendData2 = XEntityDataImpl.create((String[][])new String[][]{{"SharableReportProblem"}});
    XEntityData infoData = XEntityDataImpl.create((String[][])new String[][]{{"SharableReportProblem"}, {"eMail", "no"}, {"other", "no"}});

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createFilenameLogControl(composite);
        this.createStackTracesControl(composite);
        this.createProblemControl(composite);
        this.createContactInfoControl(composite);
        this.initializeData();
        return composite;
    }

    public void updateBar() {
        this.getCommandBar().setEnabled(OK, !this.isMessageEmpty());
    }

    void validate() {
        if (this.problemDescription == null || this.problemDescription.isDisposed()) {
            return;
        }
        String text = this.problemDescription.getText();
        if (text == null || text.trim().length() == 0) {
            this.setErrorMessage(UIMessages.REPORT_PROBLEM_NO_DESCRIPTION);
        } else {
            this.setErrorMessage(null);
            this.setMessage(UIMessages.REPORT_PROBLEM_DESCRIPTION);
        }
    }

    public Point getPreferredSize() {
        return new Point(750, 500);
    }

    public String[] getCommands() {
        return new String[]{OK, CANCEL};
    }

    public void action(String command) {
        if (command.equals(OK)) {
            this.submitProblems();
            super.action(OK);
        } else {
            super.action(command);
        }
    }

    private void initializeData() {
        File defaultLocation = new File(Platform.getLocation().toFile(), this.getDefaultZipFilename());
        this.logFileName.setText(defaultLocation.toString());
    }

    private byte[] getEclipseLogContent() {
        StringBuffer sb = new StringBuffer();
        String location = Platform.getLogFileLocation().toOSString();
        File f = new File(location);
        if (!f.isFile()) {
            return sb.toString().getBytes();
        }
        try {
            FileReader in = new FileReader(location);
            char[] tempBuffer = new char[512];
            while (in.read(tempBuffer) != -1) {
                sb.append(tempBuffer);
            }
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return this.getLogByCurentDate(sb.toString()).getBytes();
    }

    private String getLogByCurentDate(String log) {
        String lastOldSession = "";
        boolean isAccept = false;
        Date today = new Date();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(log, "\n", true);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.startsWith("!SESSION")) {
                String dateString = t.substring(9, 25);
                try {
                    Date date = SESSION_DATE_FORMAT.parse(dateString);
                    long delta = today.getTime() - date.getTime();
                    if (delta < 86400000L) {
                        if (!isAccept) {
                            sb.append(String.valueOf(lastOldSession) + "\n");
                        }
                        sb.append(t);
                        isAccept = true;
                        continue;
                    }
                    lastOldSession = new String(t);
                    isAccept = false;
                }
                catch (ParseException parseException) {
                    sb.append(t);
                    isAccept = true;
                }
                continue;
            }
            if (!isAccept) continue;
            sb.append(t);
        }
        return sb.toString();
    }

    private byte[] getUserCommentContent() {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("email : ").append(ReportPreference.E_MAIL_OPTION.getValue()).append("\n");
        sb = sb.append("description : ").append(this.problemDescription.getText()).append("\n");
        sb.append("other : ").append(ReportPreference.OTHER_OPTION.getValue()).append("\n");
        return sb.toString().getBytes();
    }

    private byte[] getEclipsePropertiesContent() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println(NLS.bind((String)WorkbenchMessages.SystemSummary_timeStamp, (Object)DateFormat.getDateTimeInstance(0, 0).format(new Date())));
        this.appendExtensions(writer);
        writer.close();
        return out.toString().getBytes();
    }

    private void createZipFile() throws IOException {
        File zipFilename = new File(this.logFileName.getText());
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zipFilename));
        try {
            this.addFileToZip(this.getEclipseLogContent(), "eclipse.log", zout);
            this.addFileToZip(this.getUserCommentContent(), "usercomment.txt", zout);
            this.addFileToZip(this.getEclipsePropertiesContent(), "eclipse.properties", zout);
            ModelUIPlugin.getDefault().logInfo("Wrote diagnostic info to " + zipFilename);
        }
        finally {
            zout.close();
        }
    }

    private void addFileToZip(byte[] tempBuffer, String fileName, ZipOutputStream zout) throws IOException {
        ZipEntry e = new ZipEntry(fileName);
        zout.putNextEntry(e);
        zout.write(tempBuffer, 0, tempBuffer.length);
        zout.closeEntry();
    }

    private String getDefaultZipFilename() {
        Date today = new Date();
        String currentDate = LOG_DATE_FORMAT.format(today);
        return "jbosstools-diagnostics-" + currentDate.toString() + ".zip";
    }

    private void createStackTracesControl(Composite parent) {
        this.stackTracesCount = ProblemReportingHelper.buffer.getSize();
        this.exceptionsObject.setAttributeValue("exceptions", this.formatContent(ProblemReportingHelper.buffer.getContent()));
        XEntityData data = this.stackTracesCount > 0 ? this.sendData : this.sendData2;
        boolean isSeparatorNeeded = false;
        if (this.stackTracesCount > 0) {
            this.createStackTracesLabelControl(parent);
            isSeparatorNeeded = true;
        }
        if (data.getAttributeData().length > 0) {
            this.sendSupport = new XAttributeSupport(this.reportOptions, data, true);
            this.sendSupport.setAutoStore(false);
            GridLayout layout = this.getDefaultSupportLayout();
            layout.marginWidth = 10;
            this.sendSupport.setLayout((Layout)layout);
            this.sendSupport.createControl(parent);
            this.sendSupport.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ReportProblemWizardView.this.updateBar();
                }
            });
            isSeparatorNeeded = true;
        } else {
            this.sendSupport = null;
        }
        if (isSeparatorNeeded) {
            Label separator = new Label(parent, 258);
            separator.setLayoutData((Object)new GridData(768));
        }
    }

    private void createFilenameLogControl(final Composite parent) {
        Group g = new Group(parent, 16);
        g.setLayoutData((Object)new GridData(256));
        GridLayout layout = new GridLayout(3, false);
        g.setLayout((Layout)layout);
        this.createLabel((Composite)g, "Log file name", 1);
        this.logFileName = this.createSingleText((Composite)g, 1);
        this.browseButton = this.createPushButton((Composite)g, "&Browse...", null);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(parent.getShell(), 8192);
                fileDialog.setText("Save");
                File fileName = new File(ReportProblemWizardView.this.logFileName.getText());
                fileDialog.setFilterPath(fileName.getParent());
                fileDialog.setFileName(fileName.getName());
                String[] filterExt = new String[]{"*.zip"};
                fileDialog.setFilterExtensions(filterExt);
                String selected = fileDialog.open();
                if (selected != null) {
                    ReportProblemWizardView.this.logFileName.setText(selected);
                }
            }
        });
    }

    private void createProblemControl(Composite parent) {
        Group g = new Group(parent, 16);
        g.setText("Problem Description");
        g.setLayoutData((Object)new GridData(1808));
        g.setLayout((Layout)new GridLayout());
        this.problemDescription = new Text((Composite)g, 2818);
        this.problemDescription.setLayoutData((Object)new GridData(1808));
        this.problemDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReportProblemWizardView.this.validate();
                ReportProblemWizardView.this.updateBar();
            }
        });
    }

    private void createContactInfoControl(Composite parent) {
        Group g = new Group(parent, 16);
        g.setText("Contact Information (optional)");
        g.setLayoutData((Object)new GridData(768));
        g.setLayout((Layout)new GridLayout());
        this.infoSupport = new XAttributeSupport(this.reportOptions, this.infoData, true);
        this.infoSupport.setAutoStore(false);
        this.infoSupport.setLayout((Layout)this.getDefaultSupportLayout());
        Composite c = this.infoSupport.createControl((Composite)g);
        c.setLayoutData((Object)new GridData(768));
        this.infoSupport.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ReportProblemWizardView.this.validate();
            }
        });
    }

    private void createStackTracesLabelControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = this.getDefaultSupportLayout();
        layout.marginWidth = 10;
        panel.setLayout((Layout)layout);
        Label image = new Label(panel, 0);
        image.setImage(ModelUIImages.getImage("warning.gif"));
        GridData d = new GridData();
        d.widthHint = 16;
        image.setLayoutData((Object)d);
        image.setLayoutData((Object)new GridData());
        TextAndReferenceComponent t2 = new TextAndReferenceComponent(panel, 0);
        d = new GridData(768);
        d.horizontalIndent = 5;
        t2.setLayoutData(d);
        String text = "You have " + this.stackTracesCount + " stack traces to send (<a>see details</a>).";
        t2.setText(text, 300);
        t2.addReferenceListener(new ReferenceListener(){

            public void referenceSelected(String reference) {
                XActionInvoker.invoke((String)"EditActions.Edit", (XModelObject)ReportProblemWizardView.this.exceptionsObject, null);
            }
        });
    }

    private void submitProblems() {
        boolean addEclipseLog;
        if (this.sendSupport != null) {
            this.sendSupport.store();
        }
        if (this.infoSupport != null) {
            this.infoSupport.store();
        }
        String text = String.valueOf(CommonPlugin.getEnvironment()) + "\n" + this.problemDescription.getText();
        boolean addRedHatLog = "yes".equals(ReportPreference.ATTACH_REDHAT_LOG_OPTION.getValue());
        if (addRedHatLog && this.stackTracesCount > 0) {
            String log = this.exceptionsObject.getAttributeValue("exceptions");
            text = String.valueOf(text) + "\n----------Red Hat Log-----------\n" + log + "\n";
        }
        if (addEclipseLog = "yes".equals(ReportPreference.ATTACH_ECLIPSE_LOG_OPTION.getValue())) {
            String eclipseLog = ProblemReportingHelper.buffer.getEclipseLogContent();
            text = String.valueOf(text) + "\n----------Eclipse Log----------\n" + eclipseLog + "\n";
        }
        try {
            this.createZipFile();
            this.showConfirmDialog();
        }
        catch (IOException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void showConfirmDialog() {
        final String filename = this.logFileName.getText();
        String message = NLS.bind((String)UIMessages.REPORT_PROBLEM_RESULT, (Object)filename);
        MessageDialog dialog = new MessageDialog(this.problemDescription.getShell(), "Info", null, message, 2, new String[]{UIMessages.REPORT_PROBLEM_COPY_BUTTON, "Close"}, 1){

            protected void buttonPressed(int buttonId) {
                if (buttonId == 0) {
                    Clipboard clipboard = new Clipboard(ReportProblemWizardView.this.problemDescription.getShell().getDisplay());
                    try {
                        clipboard.setContents((Object[])new String[]{filename}, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        clipboard.dispose();
                    }
                }
                super.buttonPressed(buttonId);
            }
        };
        dialog.open();
    }

    /*
     * Unable to fully structure code
     */
    private String formatContent(String content) {
        sb = new StringBuffer();
        st = new StringTokenizer(content, "\n", true);
        while (st.hasMoreTokens()) {
            t = st.nextToken();
            if (!"\n".equals(t)) ** GOTO lbl16
            sb.append(t);
            continue;
lbl-1000:
            // 1 sources

            {
                t1 = t.substring(0, 70);
                i = t1.lastIndexOf(32);
                if (i > 40) {
                    t1 = t1.substring(0, i);
                }
                t = t.substring(t1.length());
                sb.append(t1).append("\n");
lbl16:
                // 2 sources

                ** while (t.length() > 70)
            }
lbl17:
            // 1 sources

            sb.append(t);
        }
        return sb.toString();
    }

    private boolean isMessageEmpty() {
        String text;
        if (this.sendSupport != null) {
            IModelPropertyEditorAdapter a = this.sendSupport.getPropertyEditorAdapterByName("attachRedHatLog");
            if (a != null && "yes".equals(a.getValue())) {
                return false;
            }
            a = this.sendSupport.getPropertyEditorAdapterByName("attachEclipseLog");
            if (a != null && "yes".equals(a.getValue())) {
                return false;
            }
        }
        return (text = this.problemDescription.getText()) == null || text.trim().length() == 0;
    }

    private Label createLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    private Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        gd.widthHint = 100;
        t.setLayoutData((Object)gd);
        return t;
    }

    private int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private void setButtonDimensionHint(Button button) {
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = this.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    private Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        this.setButtonDimensionHint(button);
        return button;
    }

    private IConfigurationElement[] getSortedExtensions() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "systemSummarySections");
        Arrays.sort(configElements, new Comparator(){
            Collator collator = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IConfigurationElement element1 = (IConfigurationElement)a;
                IConfigurationElement element2 = (IConfigurationElement)b;
                String id1 = element1.getAttribute("id");
                String id2 = element2.getAttribute("id");
                if (id1 != null && id2 != null && !id1.equals(id2)) {
                    return this.collator.compare(id1, id2);
                }
                String title1 = element1.getAttribute("sectionTitle");
                String title2 = element2.getAttribute("sectionTitle");
                if (title1 == null) {
                    title1 = "";
                }
                if (title2 == null) {
                    title2 = "";
                }
                return this.collator.compare(title1, title2);
            }
        });
        return configElements;
    }

    private void appendExtensions(PrintWriter writer) {
        IConfigurationElement[] configElements = this.getSortedExtensions();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement element = configElements[i];
            Object obj = null;
            try {
                obj = WorkbenchPlugin.createExtension((IConfigurationElement)element, (String)"class");
            }
            catch (CoreException e) {
                WorkbenchPlugin.log((String)"could not create class attribute for extension", (IStatus)e.getStatus());
            }
            writer.println();
            writer.println(NLS.bind((String)WorkbenchMessages.SystemSummary_sectionTitle, (Object)element.getAttribute("sectionTitle")));
            if (obj instanceof ISystemSummarySection) {
                ISystemSummarySection logSection = (ISystemSummarySection)obj;
                logSection.write(writer);
            } else {
                writer.println(WorkbenchMessages.SystemSummary_sectionError);
            }
            ++i;
        }
    }

    protected GridLayout getDefaultSupportLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 5;
        return gridLayout;
    }

    class PixelConverter {
        private FontMetrics fFontMetrics;

        public PixelConverter(Control control) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            this.fFontMetrics = gc.getFontMetrics();
            gc.dispose();
        }

        public int convertHorizontalDLUsToPixels(int dlus) {
            return Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)dlus);
        }

        public int convertWidthInCharsToPixels(int chars) {
            return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
        }
    }
}

