/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorMoveAction;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;
import org.jboss.tools.common.model.ui.views.navigator.NCopyAction;
import org.jboss.tools.common.model.ui.views.navigator.NCutAction;
import org.jboss.tools.common.model.ui.views.navigator.NDeleteAction;
import org.jboss.tools.common.model.ui.views.navigator.NPasteAction;

public class NRefactorActionGroup
extends ResourceNavigatorActionGroup {
    private Clipboard clipboard;
    private ResourceNavigatorRenameAction rename;
    private ResourceNavigatorMoveAction move;
    private NCopyAction copy;
    private NCutAction cut;
    private NDeleteAction delete;
    private NPasteAction paste;
    private BaseSelectionListenerAction[] actions;
    private TextActionHandler handler;

    public NRefactorActionGroup(IResourceNavigator navigator) {
        super(navigator);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        BaseSelectionListenerAction[] g = new BaseSelectionListenerAction[]{this.copy, this.cut, this.paste};
        this.add(menu, g, selection);
        if (this.isAny(selection)) {
            g = new BaseSelectionListenerAction[]{this.delete, this.move, this.rename};
            this.add(menu, g, selection);
        }
    }

    void add(IMenuManager menu, BaseSelectionListenerAction[] g, IStructuredSelection selection) {
        int i = 0;
        while (i < g.length) {
            g[i].selectionChanged(selection);
            menu.add((IAction)g[i]);
            ++i;
        }
    }

    boolean isAny(IStructuredSelection selection) {
        return !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.handler = new TextActionHandler(actionBars);
        this.handler.setDeleteAction((IAction)this.delete);
        this.handler.setCopyAction((IAction)this.copy);
        this.handler.setCutAction((IAction)this.cut);
        this.handler.setPasteAction((IAction)this.paste);
        this.rename.setTextActionHandler(this.handler);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.move);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.rename);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (this.isDelete(event)) {
            if (this.delete.isEnabled()) {
                this.delete.run();
            }
            event.doit = false;
        } else if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.rename.isEnabled()) {
                this.rename.run();
            }
            event.doit = false;
        }
    }

    boolean isDelete(KeyEvent event) {
        return event.character == '\u007f' && event.stateMask == 0;
    }

    protected void makeActions() {
        Shell shell = this.navigator.getSite().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.makePaste(shell, images);
        this.makeCopy(shell, images);
        this.makeCut(shell, images);
        this.makeDelete(shell, images);
        this.move = new ResourceNavigatorMoveAction(shell, (StructuredViewer)this.navigator.getViewer());
        this.rename = new ResourceNavigatorRenameAction(shell, this.navigator.getViewer());
        this.actions = new BaseSelectionListenerAction[]{this.copy, this.cut, this.delete, this.paste, this.rename, this.move};
    }

    private void makePaste(Shell shell, ISharedImages images) {
        this.paste = new NPasteAction(shell, this.clipboard);
        this.dressAction(this.paste, shell, images, "IMG_TOOL_PASTE_DISABLED", "IMG_TOOL_PASTE");
    }

    private void makeCopy(Shell shell, ISharedImages images) {
        this.copy = new NCopyAction(shell, this.clipboard, this.paste);
        this.dressAction(this.copy, shell, images, "IMG_TOOL_COPY_DISABLED", "IMG_TOOL_COPY");
    }

    private void makeCut(Shell shell, ISharedImages images) {
        this.cut = new NCutAction(shell, this.paste);
        this.dressAction(this.cut, shell, images, "IMG_TOOL_CUT_DISABLED", "IMG_TOOL_CUT");
    }

    private void makeDelete(Shell shell, ISharedImages images) {
        this.delete = new NDeleteAction(shell);
        this.dressAction(this.delete, shell, images, "IMG_TOOL_DELETE_DISABLED", "IMG_TOOL_DELETE");
    }

    private void dressAction(BaseSelectionListenerAction action, Shell shell, ISharedImages images, String disabledId, String enabledId) {
        if (disabledId != null) {
            action.setDisabledImageDescriptor(images.getImageDescriptor(disabledId));
        }
        if (enabledId != null) {
            action.setImageDescriptor(images.getImageDescriptor(enabledId));
        }
    }

    public void updateActionBars() {
        if (this.actions == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        int i = 0;
        while (i < this.actions.length) {
            this.actions[i].selectionChanged(selection);
            ++i;
        }
    }
}

