/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mozilla;

import javax.swing.event.EventListenerList;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaAfterPaintListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaContextMenuListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaDndListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaKeyListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaMouseListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaScrollListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaSelectionListener;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISelectionListener;
import org.mozilla.interfaces.nsISelectionPrivate;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class MozillaEventAdapter
implements nsIDOMEventListener,
nsISelectionListener {
    private static final String MOZAFTERPAINT = "MozAfterPaint";
    private static final String SCROLL = "scroll";
    private static final String MOUSEMOVEEVENTTYPE = "mousemove";
    private static final String MOUSEDOWNEVENTTYPE = "mousedown";
    private static final String MOUSEUPEVENTTYPE = "mouseup";
    private static final String CLICKEVENTTYPE = "click";
    private static final String KEYPRESS = "keypress";
    private static final String DBLCLICK = "dblclick";
    private static final String CONTEXTMENUEVENTTYPE = "contextmenu";
    private static final String DRAGSTART = "dragstart";
    private static final String DRAGOVEREVENT = "dragover";
    private static final String DRAGDROPEVENT = "dragdrop";
    private static final String DRAGENTEREVENT = "dragenter";
    private static final String DRAGEXITEVENT = "dragexit";
    private static final String DRAGEND = "dragend";
    private EventListenerList listeners = new EventListenerList();
    private nsIDOMEventTarget window;
    private nsIDOMEventTarget document;
    private nsIDOMEventTarget contentArea;
    private nsISelectionPrivate selectionPrivate;
    private boolean attached = false;

    public void attach(nsIDOMWindow domWindow, nsIDOMEventTarget contentArea) {
        if (this.attached) {
            new IllegalStateException("Instance of the MozillaMouseListener cannot be attached twice.");
        }
        this.attached = true;
        this.window = (nsIDOMEventTarget)XPCOM.queryInterface((nsISupports)domWindow, nsIDOMEventTarget.class);
        this.document = (nsIDOMEventTarget)XPCOM.queryInterface((nsISupports)domWindow.getDocument(), nsIDOMEventTarget.class);
        this.contentArea = contentArea;
        if (contentArea != null) {
            contentArea.addEventListener(CLICKEVENTTYPE, (nsIDOMEventListener)this, false);
            contentArea.addEventListener(MOUSEDOWNEVENTTYPE, (nsIDOMEventListener)this, false);
            contentArea.addEventListener(MOUSEUPEVENTTYPE, (nsIDOMEventListener)this, false);
            contentArea.addEventListener(MOUSEMOVEEVENTTYPE, (nsIDOMEventListener)this, false);
            contentArea.addEventListener(CONTEXTMENUEVENTTYPE, (nsIDOMEventListener)this, false);
            contentArea.addEventListener(DBLCLICK, (nsIDOMEventListener)this, false);
            contentArea.addEventListener(DRAGSTART, (nsIDOMEventListener)this, false);
        }
        if (this.window != null) {
            this.window.addEventListener(MOZAFTERPAINT, (nsIDOMEventListener)this, false);
            nsISelection selection = domWindow.getSelection();
            this.selectionPrivate = (nsISelectionPrivate)XPCOM.queryInterface((nsISupports)selection, nsISelectionPrivate.class);
            this.selectionPrivate.addSelectionListener((nsISelectionListener)this);
        }
        if (this.document != null) {
            this.document.addEventListener(DRAGDROPEVENT, (nsIDOMEventListener)this, false);
            this.document.addEventListener(DRAGENTEREVENT, (nsIDOMEventListener)this, false);
            this.document.addEventListener(DRAGEND, (nsIDOMEventListener)this, false);
            this.document.addEventListener(DRAGEXITEVENT, (nsIDOMEventListener)this, false);
            this.document.addEventListener(DRAGOVEREVENT, (nsIDOMEventListener)this, false);
            this.document.addEventListener(KEYPRESS, (nsIDOMEventListener)this, false);
            this.document.addEventListener(SCROLL, (nsIDOMEventListener)this, false);
        }
    }

    public void detach() {
        this.attached = false;
        if (this.contentArea != null) {
            this.contentArea.removeEventListener(CLICKEVENTTYPE, (nsIDOMEventListener)this, false);
            this.contentArea.removeEventListener(MOUSEDOWNEVENTTYPE, (nsIDOMEventListener)this, false);
            this.contentArea.removeEventListener(MOUSEUPEVENTTYPE, (nsIDOMEventListener)this, false);
            this.contentArea.removeEventListener(MOUSEMOVEEVENTTYPE, (nsIDOMEventListener)this, false);
            this.contentArea.removeEventListener(CONTEXTMENUEVENTTYPE, (nsIDOMEventListener)this, false);
            this.contentArea.removeEventListener(DBLCLICK, (nsIDOMEventListener)this, false);
            this.contentArea.removeEventListener(DRAGSTART, (nsIDOMEventListener)this, false);
            this.contentArea = null;
        }
        if (this.document != null) {
            this.document.removeEventListener(DRAGDROPEVENT, (nsIDOMEventListener)this, false);
            this.document.removeEventListener(DRAGENTEREVENT, (nsIDOMEventListener)this, false);
            this.document.removeEventListener(DRAGEND, (nsIDOMEventListener)this, false);
            this.document.removeEventListener(DRAGEXITEVENT, (nsIDOMEventListener)this, false);
            this.document.removeEventListener(DRAGOVEREVENT, (nsIDOMEventListener)this, false);
            this.document.removeEventListener(KEYPRESS, (nsIDOMEventListener)this, false);
            this.document.removeEventListener(SCROLL, (nsIDOMEventListener)this, false);
            this.document = null;
        }
        if (this.window != null) {
            this.window.removeEventListener(MOZAFTERPAINT, (nsIDOMEventListener)this, false);
            this.window = null;
        }
        if (this.selectionPrivate != null) {
            try {
                try {
                    this.selectionPrivate.removeSelectionListener((nsISelectionListener)this);
                }
                catch (XPCOMException xpcomException) {
                    if (xpcomException.errorcode != 2147500037L) {
                        throw xpcomException;
                    }
                    this.selectionPrivate = null;
                }
            }
            finally {
                this.selectionPrivate = null;
            }
        }
    }

    public void addMouseListener(MozillaMouseListener listener) {
        this.listeners.add(MozillaMouseListener.class, listener);
    }

    public void removeMouseListener(MozillaMouseListener listener) {
        this.listeners.remove(MozillaMouseListener.class, listener);
    }

    public void addKeyListener(MozillaKeyListener listener) {
        this.listeners.add(MozillaKeyListener.class, listener);
    }

    public void removeKeyListener(MozillaKeyListener listener) {
        this.listeners.remove(MozillaKeyListener.class, listener);
    }

    public void addContextMenuListener(MozillaContextMenuListener listener) {
        this.listeners.add(MozillaContextMenuListener.class, listener);
    }

    public void removeContextMenuListener(MozillaContextMenuListener listener) {
        this.listeners.remove(MozillaContextMenuListener.class, listener);
    }

    public void addDndListener(MozillaDndListener listener) {
        this.listeners.add(MozillaDndListener.class, listener);
    }

    public void removeDndListener(MozillaDndListener listener) {
        this.listeners.remove(MozillaDndListener.class, listener);
    }

    public void addSelectionListener(MozillaSelectionListener listener) {
        this.listeners.add(MozillaSelectionListener.class, listener);
    }

    public void removeSelectionListener(MozillaSelectionListener listener) {
        this.listeners.remove(MozillaSelectionListener.class, listener);
    }

    public void addAfterPaintListener(MozillaAfterPaintListener listener) {
        this.listeners.add(MozillaAfterPaintListener.class, listener);
    }

    public void removeAfterPaintListener(MozillaAfterPaintListener listener) {
        this.listeners.remove(MozillaAfterPaintListener.class, listener);
    }

    public void addScrollListener(MozillaScrollListener listener) {
        this.listeners.add(MozillaScrollListener.class, listener);
    }

    public void removeScrollListener(MozillaScrollListener listener) {
        this.listeners.remove(MozillaScrollListener.class, listener);
    }

    public void notifySelectionChanged(nsIDOMDocument domDocument, nsISelection selection, short reason) {
        MozillaSelectionListener[] mozillaSelectionListenerArray = (MozillaSelectionListener[])this.listeners.getListeners(MozillaSelectionListener.class);
        int n = mozillaSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MozillaSelectionListener listener = mozillaSelectionListenerArray[n2];
            listener.notifySelectionChanged(domDocument, selection, reason);
            ++n2;
        }
    }

    public void handleEvent(nsIDOMEvent domEvent) {
        block14: {
            String eventType;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block13: {
                                                            eventType = domEvent.getType();
                                                            if (!MOUSEMOVEEVENTTYPE.equals(eventType)) break block13;
                                                            nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMMouseEvent.class);
                                                            MozillaMouseListener[] mozillaMouseListenerArray = (MozillaMouseListener[])this.listeners.getListeners(MozillaMouseListener.class);
                                                            int n = mozillaMouseListenerArray.length;
                                                            int n2 = 0;
                                                            while (n2 < n) {
                                                                MozillaMouseListener listener = mozillaMouseListenerArray[n2];
                                                                listener.mouseMove(mouseEvent);
                                                                ++n2;
                                                            }
                                                            break block14;
                                                        }
                                                        if (!MOUSEDOWNEVENTTYPE.equals(eventType)) break block15;
                                                        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMMouseEvent.class);
                                                        MozillaMouseListener[] mozillaMouseListenerArray = (MozillaMouseListener[])this.listeners.getListeners(MozillaMouseListener.class);
                                                        int n = mozillaMouseListenerArray.length;
                                                        int n3 = 0;
                                                        while (n3 < n) {
                                                            MozillaMouseListener listener = mozillaMouseListenerArray[n3];
                                                            listener.mouseDown(mouseEvent);
                                                            ++n3;
                                                        }
                                                        break block14;
                                                    }
                                                    if (!MOUSEUPEVENTTYPE.equals(eventType)) break block16;
                                                    nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMMouseEvent.class);
                                                    MozillaMouseListener[] mozillaMouseListenerArray = (MozillaMouseListener[])this.listeners.getListeners(MozillaMouseListener.class);
                                                    int n = mozillaMouseListenerArray.length;
                                                    int n4 = 0;
                                                    while (n4 < n) {
                                                        MozillaMouseListener listener = mozillaMouseListenerArray[n4];
                                                        listener.mouseUp(mouseEvent);
                                                        ++n4;
                                                    }
                                                    break block14;
                                                }
                                                if (!CLICKEVENTTYPE.equals(eventType)) break block17;
                                                nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMMouseEvent.class);
                                                MozillaMouseListener[] mozillaMouseListenerArray = (MozillaMouseListener[])this.listeners.getListeners(MozillaMouseListener.class);
                                                int n = mozillaMouseListenerArray.length;
                                                int n5 = 0;
                                                while (n5 < n) {
                                                    MozillaMouseListener listener = mozillaMouseListenerArray[n5];
                                                    listener.mouseClick(mouseEvent);
                                                    ++n5;
                                                }
                                                break block14;
                                            }
                                            if (!DBLCLICK.equals(eventType)) break block18;
                                            nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMMouseEvent.class);
                                            MozillaMouseListener[] mozillaMouseListenerArray = (MozillaMouseListener[])this.listeners.getListeners(MozillaMouseListener.class);
                                            int n = mozillaMouseListenerArray.length;
                                            int n6 = 0;
                                            while (n6 < n) {
                                                MozillaMouseListener listener = mozillaMouseListenerArray[n6];
                                                listener.mouseDblClick(mouseEvent);
                                                ++n6;
                                            }
                                            break block14;
                                        }
                                        if (!KEYPRESS.equals(eventType)) break block19;
                                        nsIDOMKeyEvent keyEvent = (nsIDOMKeyEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMKeyEvent.class);
                                        MozillaKeyListener[] mozillaKeyListenerArray = (MozillaKeyListener[])this.listeners.getListeners(MozillaKeyListener.class);
                                        int n = mozillaKeyListenerArray.length;
                                        int n7 = 0;
                                        while (n7 < n) {
                                            MozillaKeyListener listener = mozillaKeyListenerArray[n7];
                                            listener.keyPress(keyEvent);
                                            ++n7;
                                        }
                                        break block14;
                                    }
                                    if (!CONTEXTMENUEVENTTYPE.equals(eventType)) break block20;
                                    nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)domEvent.getTarget(), nsIDOMNode.class);
                                    MozillaContextMenuListener[] mozillaContextMenuListenerArray = (MozillaContextMenuListener[])this.listeners.getListeners(MozillaContextMenuListener.class);
                                    int n = mozillaContextMenuListenerArray.length;
                                    int n8 = 0;
                                    while (n8 < n) {
                                        MozillaContextMenuListener listener = mozillaContextMenuListenerArray[n8];
                                        listener.onShowContextMenu(0L, domEvent, node);
                                        ++n8;
                                    }
                                    break block14;
                                }
                                if (DRAGSTART.equals(eventType)) break block14;
                                if (!DRAGDROPEVENT.equals(eventType)) break block21;
                                MozillaDndListener[] mozillaDndListenerArray = (MozillaDndListener[])this.listeners.getListeners(MozillaDndListener.class);
                                int n = mozillaDndListenerArray.length;
                                int n9 = 0;
                                while (n9 < n) {
                                    MozillaDndListener listener = mozillaDndListenerArray[n9];
                                    listener.dragDrop(domEvent);
                                    ++n9;
                                }
                                domEvent.stopPropagation();
                                domEvent.preventDefault();
                                break block14;
                            }
                            if (DRAGENTEREVENT.equals(eventType)) break block14;
                            if (!DRAGEND.equals(eventType)) break block22;
                            MozillaDndListener[] mozillaDndListenerArray = (MozillaDndListener[])this.listeners.getListeners(MozillaDndListener.class);
                            int n = mozillaDndListenerArray.length;
                            int n10 = 0;
                            while (n10 < n) {
                                MozillaDndListener listener = mozillaDndListenerArray[n10];
                                listener.dragEnd(domEvent);
                                ++n10;
                            }
                            break block14;
                        }
                        if (!DRAGEXITEVENT.equals(eventType)) break block23;
                        MozillaDndListener[] mozillaDndListenerArray = (MozillaDndListener[])this.listeners.getListeners(MozillaDndListener.class);
                        int n = mozillaDndListenerArray.length;
                        int n11 = 0;
                        while (n11 < n) {
                            MozillaDndListener listener = mozillaDndListenerArray[n11];
                            listener.dragExit(domEvent);
                            ++n11;
                        }
                        break block14;
                    }
                    if (!DRAGOVEREVENT.equals(eventType)) break block24;
                    MozillaDndListener[] mozillaDndListenerArray = (MozillaDndListener[])this.listeners.getListeners(MozillaDndListener.class);
                    int n = mozillaDndListenerArray.length;
                    int n12 = 0;
                    while (n12 < n) {
                        MozillaDndListener listener = mozillaDndListenerArray[n12];
                        listener.dragOver(domEvent);
                        ++n12;
                    }
                    break block14;
                }
                if (!SCROLL.equals(eventType)) break block25;
                MozillaScrollListener[] mozillaScrollListenerArray = (MozillaScrollListener[])this.listeners.getListeners(MozillaScrollListener.class);
                int n = mozillaScrollListenerArray.length;
                int n13 = 0;
                while (n13 < n) {
                    MozillaScrollListener listener = mozillaScrollListenerArray[n13];
                    listener.editorScrolled(domEvent);
                    ++n13;
                }
                break block14;
            }
            if (!MOZAFTERPAINT.equals(eventType)) break block14;
            MozillaAfterPaintListener[] mozillaAfterPaintListenerArray = (MozillaAfterPaintListener[])this.listeners.getListeners(MozillaAfterPaintListener.class);
            int n = mozillaAfterPaintListenerArray.length;
            int n14 = 0;
            while (n14 < n) {
                MozillaAfterPaintListener listener = mozillaAfterPaintListenerArray[n14];
                listener.afterPaint(domEvent);
                ++n14;
            }
        }
    }

    public nsISupports queryInterface(String arg0) {
        return Mozilla.queryInterface((nsISupports)this, (String)arg0);
    }
}

