/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.el.core.ELReferenceList;
import org.jboss.tools.common.el.core.GlobalELReferenceList;
import org.jboss.tools.common.resref.core.ResourceReference;

public class ElServiceUtil {
    public static final String DOLLAR_PREFIX = "${";
    public static final String SUFFIX = "}";
    public static final String SHARP_PREFIX = "#{";

    public static String replaceEl(IFile file, String resourceString) {
        if (resourceString == null) {
            return "";
        }
        String rst = resourceString;
        ResourceReference[] references = ElServiceUtil.getAllResources(file);
        if (references == null || references.length == 0) {
            return rst;
        }
        references = ElServiceUtil.sortReferencesByScope2(references);
        rst = ElServiceUtil.replace(resourceString, references);
        return rst;
    }

    public static ResourceReference[] sortReferencesByScope(ResourceReference[] references) {
        ResourceReference[] sortedReferences = (ResourceReference[])references.clone();
        return ElServiceUtil.sortReferencesByScope(sortedReferences);
    }

    public static ResourceReference[] sortReferencesByScope2(ResourceReference[] references) {
        Arrays.sort(references, new Comparator<ResourceReference>(){

            @Override
            public int compare(ResourceReference r1, ResourceReference r2) {
                return r1.getScope() - r2.getScope();
            }
        });
        return references;
    }

    public static ResourceReference[] getAllResources(IFile resourceFile) {
        IPath workspacePath = Platform.getLocation();
        ResourceReference[] gResources = GlobalELReferenceList.getInstance().getAllResources(workspacePath);
        ResourceReference[] elResources = ELReferenceList.getInstance().getAllResources(resourceFile);
        int size = gResources.length;
        ResourceReference[] rst = new ResourceReference[size += elResources.length];
        if (gResources.length > 0) {
            System.arraycopy(gResources, 0, rst, 0, gResources.length);
        }
        if (elResources.length > 0) {
            System.arraycopy(elResources, 0, rst, gResources == null ? 0 : gResources.length, elResources.length);
        }
        return rst;
    }

    public static String replace(String resourceString, ResourceReference[] sortedReferences) {
        String result = resourceString;
        int nPrefLen = ElServiceUtil.getPrefLen();
        ResourceReference[] resourceReferenceArray = sortedReferences;
        int n = sortedReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference rf = resourceReferenceArray[n2];
            String tmp = rf.getLocation();
            if (tmp.length() + nPrefLen <= resourceString.length()) {
                String dollarEl = ElServiceUtil.envelopeInDollarEl(tmp);
                String sharpEl = ElServiceUtil.envelopeInSharpEl(tmp);
                if (resourceString.contains(dollarEl)) {
                    result = result.replace(dollarEl, rf.getProperties());
                }
                if (resourceString.contains(sharpEl)) {
                    result = result.replace(sharpEl, rf.getProperties());
                }
            }
            ++n2;
        }
        return result;
    }

    public static int getPrefLen() {
        int nPrefLen = DOLLAR_PREFIX.length();
        if (nPrefLen > SHARP_PREFIX.length()) {
            nPrefLen = SHARP_PREFIX.length();
        }
        return nPrefLen += SUFFIX.length();
    }

    public static boolean equalsExppression(String value, String expression) {
        String dollarEl = ElServiceUtil.envelopeInDollarEl(expression);
        String sharpEl = ElServiceUtil.envelopeInSharpEl(expression);
        return value.contains(dollarEl) || value.contains(sharpEl);
    }

    public static boolean isInReferenceResourcesList(ResourceReference[] references, String value) {
        ResourceReference[] resourceReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference ref = resourceReferenceArray[n2];
            if (ElServiceUtil.equalsExppression(value, ref.getLocation())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String envelopeInDollarEl(String str) {
        return DOLLAR_PREFIX + str + SUFFIX;
    }

    public static String envelopeInSharpEl(String str) {
        return SHARP_PREFIX + str + SUFFIX;
    }
}

