/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.constraint.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintProperties;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.w3c.dom.Element;

public class XAttributeConstraintJavaName
extends XAttributeConstraintProperties {
    private static final String[] keywords = new String[]{"break", "case", "catch", "class", "const", "continue", "default", "else", "extends", "false", "final", "finally", "for", "if", "implements", "import", "instanceof", "interface", "new", "null", "package", "protected", "private", "public", "return", "static", "switch", "synchronized", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final String[] primitives = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    private static final Set<String> keytable = new HashSet<String>();
    private static final Set<String> primitiveSet = new HashSet<String>();
    private Set<String> custom = null;
    boolean allowPrimitiveTypes = false;

    static {
        int i = 0;
        while (i < keywords.length) {
            keytable.add(keywords[i]);
            ++i;
        }
        i = 0;
        while (i < primitives.length) {
            primitiveSet.add(primitives[i]);
            ++i;
        }
    }

    @Override
    public void load(Element element) {
        super.load(element);
        String k = this.p.getProperty("keywords");
        if (k == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(k, ";,");
        this.custom = new HashSet<String>();
        while (st.hasMoreTokens()) {
            this.custom.add(st.nextToken());
        }
    }

    @Override
    public boolean accepts(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(value.charAt(0))) {
            return false;
        }
        if (keytable.contains(value) && !"true".equals(this.p.getProperty("acceptKeyWord"))) {
            return false;
        }
        if (!this.allowPrimitiveTypes && primitiveSet.contains(value)) {
            return false;
        }
        if (this.custom != null && this.custom.contains(value)) {
            return false;
        }
        int i = 1;
        while (i < value.length()) {
            if (!Character.isJavaIdentifierPart(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getError(String value) {
        return value.length() == 0 ? (this.isRequired() ? ModelMessages.CONSTRAINT_NONEMPTY : null) : (this.accepts(value) ? null : (keytable.contains(value) ? ModelMessages.CONSTRAINT_NO_JAVA_KEYWORD : (!this.allowPrimitiveTypes && primitiveSet.contains(value) ? ModelMessages.CONSTRAINT_NO_JAVA_KEYWORD : (this.custom != null && this.custom.contains(value) ? ModelMessages.IS_A_RESERVED_WORD : ModelMessages.CONSTRAINT_JAVA_NAME))));
    }

    boolean isRequired() {
        return this.attribute != null && "always".equals(this.attribute.getProperty("save"));
    }

    @Override
    public String getCorrectedValue(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if ("true".equals(this.getProperties().getProperty("acceptIncorrect"))) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < value.length()) {
            block7: {
                char c;
                block8: {
                    block6: {
                        c = value.charAt(i);
                        if (!first) break block6;
                        if (!Character.isJavaIdentifierStart(c)) break block7;
                        first = false;
                        break block8;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break block7;
                }
                sb.append(c);
            }
            ++i;
        }
        return sb.length() == 0 ? null : sb.toString();
    }
}

