/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl.trees;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.XAttributeConstraintT;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class FileSystemResourceTree
implements XFilteredTree {
    protected XModel model = null;
    protected Set<String> extensions = null;
    protected Set<String> entities = null;
    protected boolean javaRootsOnly = false;

    public void addExtension(String name) {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>();
        }
        this.extensions.add(name);
    }

    @Override
    public void dispose() {
        if (this.extensions != null) {
            this.extensions.clear();
        }
        this.extensions = null;
        if (this.entities != null) {
            this.entities.clear();
        }
        this.entities = null;
    }

    @Override
    public void setModel(XModel model) {
        this.model = model;
    }

    @Override
    public void setConstraint(Object object) {
        String jro;
        String ent;
        Object[] os = (Object[])object;
        XAttribute a = (XAttribute)os[0];
        XAttributeConstraintT tc = (XAttributeConstraintT)a.getConstraint();
        String ext = tc.getProperties().getProperty("extensions");
        if (ext != null) {
            this.extensions = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(ext, ",");
            while (st.hasMoreTokens()) {
                this.extensions.add(st.nextToken());
            }
        }
        if ((ent = tc.getProperties().getProperty("entities")) != null) {
            this.entities = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(ent, ",");
            while (st.hasMoreTokens()) {
                this.entities.add(st.nextToken());
            }
        }
        if ("true".equals(jro = tc.getProperties().getProperty("java_roots_only"))) {
            this.javaRootsOnly = true;
        }
    }

    @Override
    public XModelObject getRoot() {
        return FileSystemsHelper.getFileSystems(this.model);
    }

    @Override
    public boolean isSelectable(XModelObject object) {
        return object != null && object.getFileType() == 1;
    }

    @Override
    public String getValue(XModelObject object) {
        return this.getPath(object);
    }

    @Override
    public XModelObject find(String value) {
        return this.model.getByPath(value);
    }

    @Override
    public XModelObject getParent(XModelObject object) {
        XModelObject root = this.getRoot();
        if (object == root) {
            return null;
        }
        XModelObject p = object.getParent();
        return p == null ? null : (p.getParent() == root ? root : p);
    }

    @Override
    public String getPath(XModelObject object) {
        String p = object.getPath();
        if (p == null || !p.startsWith("FileSystems/")) {
            return p;
        }
        return XModelObjectLoaderUtil.getResourcePath(object);
    }

    @Override
    public boolean hasChildren(XModelObject object) {
        return object.getFileType() != 1;
    }

    @Override
    public XModelObject getChildAt(XModelObject object, int i) {
        XModelObject[] c = this.getChildren(object);
        return i < 0 || i >= c.length ? null : c[i];
    }

    @Override
    public XModelObject[] getChildren(XModelObject object) {
        if (object == this.getRoot()) {
            return this.getRootChildren();
        }
        int t = object.getFileType();
        if (t == 1) {
            return new XModelObject[0];
        }
        return this.getChildrenInFileSystems(object);
    }

    protected boolean accepts0(XModelObject o) {
        int type = o.getFileType();
        if (type == 2) {
            return !"true".equals(o.get("overlapped"));
        }
        if (type != 1) {
            return false;
        }
        String pathpart = o.getPathPart();
        String pp = pathpart.substring(pathpart.lastIndexOf(46) + 1);
        pp = pp.toLowerCase();
        String ent = o.getModelEntity().getName();
        return !(this.extensions != null && !this.extensions.contains(pp) || this.entities != null && !this.entities.contains(ent));
    }

    private XModelObject[] getRootChildren() {
        XModelObject[] fs = this.getRoot().getChildren();
        TreeMap<String, XModelObject> t = new TreeMap<String, XModelObject>();
        int i = 0;
        while (i < fs.length) {
            if (!this.javaRootsOnly || !"FileSystemFolder".equals(fs[i].getModelEntity().getName()) || fs[i].getAttributeValue("name").startsWith("src")) {
                XModelObject[] cs = fs[i].getChildren();
                int j = 0;
                while (j < cs.length) {
                    String p = cs[j].getPathPart();
                    if (!t.containsKey(p) && this.accepts0(cs[j])) {
                        t.put(p, cs[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] keys = t.keySet().toArray();
        XModelObject[] vs = new XModelObject[keys.length];
        int i2 = 0;
        while (i2 < vs.length) {
            vs[i2] = (XModelObject)t.get(keys[i2]);
            ++i2;
        }
        return vs;
    }

    private XModelObject[] getChildrenInFileSystems(XModelObject object) {
        String path = this.getPath(object);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        XModelObject[] fs = this.getRoot().getChildren();
        TreeMap<String, XModelObject> t = new TreeMap<String, XModelObject>();
        int i = 0;
        while (i < fs.length) {
            XModelObject o = fs[i].getChildByPath(path);
            if (o != null) {
                XModelObject[] cs = o.getChildren();
                int j = 0;
                while (j < cs.length) {
                    String p = cs[j].getPathPart();
                    if (!t.containsKey(p) && this.accepts0(cs[j])) {
                        t.put(p, cs[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] keys = t.keySet().toArray();
        XModelObject[] vs = new XModelObject[keys.length];
        int i2 = 0;
        while (i2 < vs.length) {
            vs[i2] = (XModelObject)t.get(keys[i2]);
            ++i2;
        }
        return vs;
    }
}

