/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class ModelEntityRecognizer
implements EntityRecognizer {
    private HashMap<String, EntityRecognizer[]> recognizers = new HashMap();
    private Set<String> umbiguousExtensions = new HashSet<String>();

    public ModelEntityRecognizer(XModelMetaData meta) {
        this.load(meta);
    }

    @Override
    public String getEntityName(EntityRecognizerContext context) {
        EntityRecognizer[] list;
        String ext = context.getExtension();
        if (ext != null) {
            ext = ext.toLowerCase();
        }
        if ((list = this.recognizers.get(ext)) == null || list.length == 0) {
            return "FileAny";
        }
        EntityRecognizer[] entityRecognizerArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            EntityRecognizer r = entityRecognizerArray[n2];
            String n3 = r.getEntityName(context);
            if (n3 != null) {
                return n3;
            }
            ++n2;
        }
        return null;
    }

    public boolean isBodyRequired(EntityRecognizerContext context, String entityForNullBody) {
        return entityForNullBody == null || context.getExtension() != null && this.umbiguousExtensions.contains(context.getExtension());
    }

    private void load(XModelMetaData meta) {
        EntityRecognizer[] rs;
        XMapping m = meta.getMapping("Recognizers");
        if (m == null) {
            return;
        }
        HashMap<String, RL> ext_list = new HashMap<String, RL>();
        HashMap<String, EntityRecognizer> cls_recw = new HashMap<String, EntityRecognizer>();
        String[] keys = m.getKeys();
        int i = 0;
        while (i < keys.length) {
            String k = keys[i];
            String clsname = m.getValue(k);
            if (clsname != null && clsname.trim().length() != 0) {
                int d;
                String ext;
                RL rl;
                EntityRecognizer r = (EntityRecognizer)cls_recw.get(clsname);
                if (r == null) {
                    r = new EntityRecognizerWrapper(clsname);
                    cls_recw.put(clsname, r);
                }
                if ((rl = (RL)ext_list.get(ext = (d = k.indexOf(36)) < 0 ? k : k.substring(0, d))) == null) {
                    rl = new RL();
                    ext_list.put(ext, rl);
                }
                int p = d < 0 ? 0 : this.parsePriority(k.substring(d + 1));
                rl.add(r, p);
            }
            ++i;
        }
        String[] ks = ext_list.keySet().toArray(new String[0]);
        int i2 = 0;
        while (i2 < ks.length) {
            RL rl = (RL)ext_list.get(ks[i2]);
            rs = rl.list();
            ext_list.remove(ks[i2]);
            if (rs.length > 0) {
                this.recognizers.put(ks[i2], rs);
            }
            ++i2;
        }
        for (String ext : this.recognizers.keySet()) {
            rs = this.recognizers.get(ext);
            if (rs == null || rs.length <= 1) continue;
            this.umbiguousExtensions.add(ext);
        }
    }

    private EntityRecognizer find(String clsname) {
        try {
            return (EntityRecognizer)ModelFeatureFactory.getInstance().createFeatureInstance(clsname);
        }
        catch (ClassCastException e) {
            ModelPlugin.getPluginLog().logError("Entity recognizer " + clsname + " must be instanceof EntityRecognizer", (Throwable)e);
            return null;
        }
    }

    private int parsePriority(String s) {
        if (s == null) {
            return 10;
        }
        try {
            return s.length() == 0 ? 0 : Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    private class EntityRecognizerWrapper
    implements EntityRecognizer {
        String clsname;
        EntityRecognizer resolved;

        public EntityRecognizerWrapper(String clsname) {
            this.clsname = clsname;
        }

        boolean checkResolved() {
            if (this.resolved == null && this.clsname != null) {
                this.resolved = ModelEntityRecognizer.this.find(this.clsname);
                this.clsname = null;
            }
            return this.resolved != null;
        }

        @Override
        public String getEntityName(EntityRecognizerContext context) {
            if (!this.checkResolved()) {
                return null;
            }
            return this.resolved.getEntityName(context);
        }
    }

    private class R {
        EntityRecognizer r;
        int p;

        R(EntityRecognizer r, int p) {
            this.r = r;
            this.p = p;
        }
    }

    private class RL {
        private Vector<R> v = new Vector(2);

        private RL() {
        }

        public void add(EntityRecognizer r, int p) {
            R x = this.resolve(r, p);
            int i = 0;
            while (i < this.v.size()) {
                R y = this.v.elementAt(i);
                if (x.p < y.p) {
                    this.v.insertElementAt(x, i);
                    return;
                }
                ++i;
            }
            this.v.addElement(x);
        }

        private R resolve(EntityRecognizer r, int p) {
            int i = 0;
            while (i < this.v.size()) {
                R x = this.v.elementAt(i);
                if (x.r == r) {
                    if (p < x.p) {
                        x.p = p;
                    }
                    this.v.removeElement(x);
                    return x;
                }
                ++i;
            }
            return new R(r, p);
        }

        public EntityRecognizer[] list() {
            EntityRecognizer[] rs = new EntityRecognizer[this.v.size()];
            int i = 0;
            while (i < this.v.size()) {
                R x = this.v.elementAt(i);
                rs[i] = x.r;
                ++i;
            }
            return rs;
        }
    }
}

