/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.markers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class XMarkerManager
implements IResourceChangeListener {
    private static XMarkerManager instance;
    private Map<IFile, Set<XModelObject>> errorObjects = new HashMap<IFile, Set<XModelObject>>();
    private Map<IFile, Set<XModelObject>> warningObjects = new HashMap<IFile, Set<XModelObject>>();
    private Set<IFile> uptodate = new HashSet<IFile>();
    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
    UpdateJob updateJob = new UpdateJob();

    public static XMarkerManager getInstance() {
        if (instance == null) {
            instance = new XMarkerManager();
        }
        return instance;
    }

    private XMarkerManager() {
        ModelPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            IProject p = (IProject)event.getResource();
            this.clear(p.getFullPath());
            return;
        }
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this.visitor);
        }
        catch (CoreException e) {
            ModelPlugin.getDefault().logError(e);
        }
    }

    private synchronized void clear(IFile f) {
        this.uptodate.remove(f);
        this.errorObjects.remove(f);
        this.warningObjects.remove(f);
    }

    private synchronized void clear(IPath f) {
        Iterator<IFile> it = this.uptodate.iterator();
        while (it.hasNext()) {
            if (!f.isPrefixOf(it.next().getFullPath())) continue;
            it.remove();
        }
        it = this.errorObjects.keySet().iterator();
        while (it.hasNext()) {
            if (!f.isPrefixOf(it.next().getFullPath())) continue;
            it.remove();
        }
        it = this.warningObjects.keySet().iterator();
        while (it.hasNext()) {
            if (!f.isPrefixOf(it.next().getFullPath())) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(IFile file) {
        Set<XModelObject> os;
        XMarkerManager xMarkerManager = this;
        synchronized (xMarkerManager) {
            if (this.uptodate.contains(file)) {
                return;
            }
            this.uptodate.add(file);
        }
        IMarker[] ms = new IMarker[]{};
        try {
            ms = file == null || !file.isAccessible() ? ModelPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2) : file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        XMarkerManager xMarkerManager2 = this;
        synchronized (xMarkerManager2) {
            os = this.errorObjects.get(file);
            if (os == null) {
                os = new HashSet<XModelObject>();
                this.errorObjects.put(file, os);
            }
        }
        this.reload(ms, os, 2);
        xMarkerManager2 = this;
        synchronized (xMarkerManager2) {
            os = this.warningObjects.get(file);
            if (os == null) {
                os = new HashSet<XModelObject>();
                this.warningObjects.put(file, os);
            }
        }
        this.reload(ms, os, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload(IMarker[] ms, Set<XModelObject> objects, int severity) {
        Object path;
        HashSet<XModelObject> es = new HashSet<XModelObject>();
        int i = 0;
        while (i < ms.length) {
            if (severity == ms[i].getAttribute("severity", 0)) {
                IResource r = ms[i].getResource();
                XModelObject o = EclipseResourceUtil.getObjectByResource(r);
                if (o == null) {
                    o = EclipseResourceUtil.createObjectForResource(r);
                }
                if (o != null) {
                    path = ms[i].getAttribute("path", null);
                    XModelObject xModelObject = o = path == null ? o : o.getModel().getByPath((String)path);
                    if (o != null) {
                        es.add(o);
                        String attr = ms[i].getAttribute("attribute", null);
                        if (attr != null && attr.length() > 0) {
                            ((XModelObjectImpl)o).addErrorAttributeDirty(attr);
                        }
                    }
                }
            }
            ++i;
        }
        HashSet<XModelObject> copy = new HashSet<XModelObject>();
        HashSet<XModelObject> toRemove = new HashSet<XModelObject>();
        HashSet<XModelObject> toAdd = new HashSet<XModelObject>();
        path = this;
        synchronized (path) {
            copy.addAll(objects);
        }
        for (XModelObject o : copy) {
            if (!es.contains(o)) {
                if (o.getErrorState() == severity) {
                    o.setErrorState(0);
                }
                toRemove.add(o);
                continue;
            }
            if (!es.contains(o)) continue;
            if (severity > o.getErrorState()) {
                o.setErrorState(severity);
            } else {
                ((XModelObjectImpl)o).commitErrorAttributes();
            }
            es.remove(o);
        }
        for (XModelObject o : es) {
            if (severity > o.getErrorState()) {
                o.setErrorState(severity);
            } else {
                ((XModelObjectImpl)o).commitErrorAttributes();
            }
            if (objects.contains(o)) continue;
            toAdd.add(o);
        }
        XMarkerManager xMarkerManager = this;
        synchronized (xMarkerManager) {
            objects.removeAll(toRemove);
            objects.addAll(toAdd);
        }
    }

    void update(XModelObject object) {
        IFile f;
        XModelObject fo = FileSystemsHelper.getFile(object);
        if (fo != null && (f = (IFile)fo.getAdapter(IFile.class)) != null && f.exists()) {
            this.reload(f);
        }
    }

    public int getErrorState(XModelObject object) {
        if (object == null) {
            return 0;
        }
        this.update(object);
        if (object.getErrorState() == 2 || object.getErrorChildCount() > 0) {
            return 2;
        }
        if (object.getErrorState() == 1 || object.getWarningChildCount() > 0) {
            return 1;
        }
        return 0;
    }

    public boolean hasErrors(XModelObject object) {
        this.update(object);
        return object != null && (object.getErrorState() == 2 || object.getErrorChildCount() > 0);
    }

    public boolean hasWarnings(XModelObject object) {
        this.update(object);
        return object != null && (object.getErrorState() == 1 || object.getWarningChildCount() > 0);
    }

    public boolean hasErrors(XModelObject object, String attribute) {
        this.update(object);
        if (attribute == null) {
            return this.hasErrors(object);
        }
        if (object.getErrorState() == 0) {
            return false;
        }
        return object.getAttributeErrorState(attribute);
    }

    public String getError(XModelObject object, String attribute) {
        IFile file;
        XModelObject f = ((XModelObjectImpl)object).getResourceAncestor();
        IFile iFile = file = f == null ? null : (IFile)f.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IMarker[] ms = null;
        try {
            ms = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (ms == null) {
            return null;
        }
        int i = 0;
        while (i < ms.length) {
            String attr;
            XModelObject o = object;
            String path = ms[i].getAttribute("path", null);
            XModelObject xModelObject = o = path == null ? o : o.getModel().getByPath(path);
            if (o != null && (attr = ms[i].getAttribute("attribute", null)) != null && attr.equals(attribute)) {
                return ms[i].getAttribute("message", null);
            }
            ++i;
        }
        return null;
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource r = delta.getResource();
            if (delta.getKind() == 2) {
                if (r instanceof IFile) {
                    XMarkerManager.this.clear((IFile)r);
                } else {
                    XMarkerManager.this.clear(r.getFullPath());
                }
                return false;
            }
            if (delta.getKind() == 1) {
                return false;
            }
            if (delta.getKind() == 0) {
                return true;
            }
            if (r instanceof IFile) {
                IFile f = (IFile)r;
                if (XMarkerManager.this.uptodate.contains(f)) {
                    ResourceDeltaVisitor resourceDeltaVisitor = this;
                    synchronized (resourceDeltaVisitor) {
                        XMarkerManager.this.uptodate.remove(f);
                    }
                    if (f.exists()) {
                        XMarkerManager.this.updateJob.add(f);
                    }
                }
            }
            return true;
        }
    }

    class UpdateJob
    implements XJob.XRunnable {
        Set<IFile> fs = new HashSet<IFile>();
        boolean running = false;

        UpdateJob() {
        }

        @Override
        public String getId() {
            return "XMarkerManager";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UpdateJob updateJob = this;
            synchronized (updateJob) {
                this.running = true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            try {
                IFile f = null;
                while ((f = this.next()) != null) {
                    XMarkerManager.this.reload(f);
                }
            }
            catch (Throwable throwable) {
                UpdateJob updateJob2 = this;
                synchronized (updateJob2) {
                    this.running = false;
                }
                throw throwable;
            }
            UpdateJob updateJob3 = this;
            synchronized (updateJob3) {
                this.running = false;
            }
        }

        synchronized IFile next() {
            if (this.fs.isEmpty()) {
                return null;
            }
            IFile f = this.fs.iterator().next();
            this.fs.remove(f);
            return f;
        }

        public synchronized void add(IFile f) {
            if (this.fs.contains(f)) {
                return;
            }
            this.fs.add(f);
            if (!this.running) {
                XJob.addRunnable(XMarkerManager.this.updateJob);
            }
        }
    }
}

