/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.helpers.MethodDescriptor;
import org.jboss.tools.struts.model.helpers.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsGenerator
implements StrutsConstants {
    public static final int OVER_FALSE = 0;
    public static final int OVER_TRUE = 1;
    public static final int OVER_ASK = 2;
    public static final String CODEGEN = "templates/generation/";
    public static final String CODEGEN_10 = "templates/generation/1.0/";
    public static final String CODEGEN_11 = "templates/generation/1.1/";
    public static final String CODEGEN_12 = "templates/generation/1.2/";
    public static final String ACTION_PATH = "action.vtl";
    public static final String FORMBEAN_PATH = "formBean.vtl";
    public static final String FORWARD_PATH = "forward.vtl";
    public static final String EXCEPTION_PATH = "exception.vtl";
    public static final String ACTION_CONFIG_PATH = "actionConfig.vtl";
    public static final String FORMBEAN_CONFIG_PATH = "formBeanConfig.vtl";
    public static final String FORWARD_CONFIG_PATH = "forwardConfig.vtl";
    public static final String EXCEPTION_CONFIG_PATH = "exceptionConfig.vtl";
    static VelocityEngine velocityEngine;
    private static String[] EXCLUDE_PKGS;
    private String basePackage = "";
    private File root;
    private int overwrite = 0;

    static {
        EXCLUDE_PKGS = new String[]{"java.", "javax.", "org.apache.struts."};
    }

    public StrutsGenerator(File root, int overwrite) {
        this.root = root;
        this.overwrite = overwrite;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String generateForward(XModelObject forward, String baseClass, String imports, boolean genProps) {
        String templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(forward)) + FORWARD_PATH;
        String className = forward.getAttributeValue("className");
        if (!this.checkClassName(className)) {
            return null;
        }
        String targetPath = new Path(String.valueOf(className.replace('.', '/')) + ".java").toOSString();
        File source = new File(this.root, targetPath);
        if (!this.checkOverwrite(source, forward.getModel())) {
            return null;
        }
        targetPath = source.getAbsolutePath();
        ArrayList<PropertyDescriptor> properties = this.getProperties(forward, genProps);
        Map<String, Object> parameters = this.getParameters(forward, className, baseClass, properties);
        this.executeTemplate(parameters, templatePath, targetPath);
        if (genProps && properties.size() > 0) {
            templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(forward)) + FORWARD_CONFIG_PATH;
            className = this.executePropertiesTemplate(parameters, forward.getModel(), templatePath, className);
        }
        return className;
    }

    public String generateException(XModelObject exception, String baseClass, String imports, boolean genProps) {
        String templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(exception)) + EXCEPTION_PATH;
        String className = exception.getAttributeValue("type");
        if (!this.checkClassName(className)) {
            return null;
        }
        String targetPath = new Path(String.valueOf(className.replace('.', '/')) + ".java").toOSString();
        File source = new File(this.root, targetPath);
        if (!this.checkOverwrite(source, exception.getModel())) {
            return null;
        }
        targetPath = source.getAbsolutePath();
        ArrayList<PropertyDescriptor> properties = this.getProperties(exception, genProps);
        Map<String, Object> parameters = this.getParameters(exception, className, baseClass, properties);
        parameters.put("constructors", this.getConstructors(exception, baseClass));
        this.executeTemplate(parameters, templatePath, targetPath);
        if (genProps && properties.size() > 0) {
            templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(exception)) + EXCEPTION_CONFIG_PATH;
            className = this.executePropertiesTemplate(parameters, exception.getModel(), templatePath, className);
        }
        return className;
    }

    public String generateFormBean(XModelObject formBean, String baseClass, String imports, boolean genProps) {
        String templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(formBean)) + FORMBEAN_PATH;
        String className = formBean.getAttributeValue("type");
        if (!this.checkClassName(className)) {
            return null;
        }
        String targetPath = new Path(String.valueOf(className.replace('.', '/')) + ".java").toOSString();
        File source = new File(this.root, targetPath);
        if (!this.checkOverwrite(source, formBean.getModel())) {
            return null;
        }
        targetPath = source.getAbsolutePath();
        ArrayList<PropertyDescriptor> properties = this.getProperties(formBean, genProps);
        Map<String, Object> parameters = this.getParameters(formBean, className, baseClass, properties);
        this.executeTemplate(parameters, templatePath, targetPath);
        if (genProps && properties.size() > 0) {
            templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(formBean)) + FORMBEAN_CONFIG_PATH;
            className = this.executePropertiesTemplate(parameters, formBean.getModel(), templatePath, className);
        }
        return className;
    }

    VelocityEngine getVelocityEngine() throws Exception {
        if (velocityEngine == null) {
            velocityEngine = new VelocityEngine();
            Properties properties = new Properties();
            IPath defaultPath = WebModelPlugin.getTemplateStatePath();
            properties.put("file.resource.loader.path", defaultPath.toOSString());
            String logFileName = Platform.getLocation().append(".metadata").append(".plugins").append("org.jboss.tools.struts").append("velocity.log").toFile().getAbsolutePath();
            properties.put("runtime.log", logFileName);
            Velocity.clearProperty((String)"file.resource.loader.path");
            velocityEngine.init(properties);
        }
        return velocityEngine;
    }

    private void executeTemplate(Map<String, Object> parameters, String templatePath, String targetPath) {
        ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
        ClassLoader c = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                VelocityContext context = new VelocityContext(parameters);
                try {
                    Template template = this.getVelocityEngine().getTemplate(templatePath);
                    File file = new File(targetPath);
                    if (file.exists() && !file.delete()) {
                        throw new RuntimeException("Unable to delete file " + file.getAbsolutePath());
                    }
                    File folder = file.getParentFile();
                    folder.mkdirs();
                    if (!folder.exists() || !folder.isDirectory()) {
                        throw new RuntimeException("Unable to create folder " + folder.getAbsolutePath());
                    }
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    if (template != null) {
                        template.merge((Context)context, (Writer)writer);
                    }
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (ResourceNotFoundException rnfe) {
                    StrutsModelPlugin.getPluginLog().logError((Throwable)rnfe);
                    d.showDialog(StrutsUIMessages.ERROR, rnfe.getMessage(), new String[]{StrutsUIMessages.OK}, null, 1);
                }
                catch (ParseErrorException pee) {
                    StrutsModelPlugin.getPluginLog().logError((Throwable)pee);
                    d.showDialog(StrutsUIMessages.ERROR, pee.getMessage(), new String[]{StrutsUIMessages.OK}, null, 1);
                }
            }
            catch (Exception e) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)e);
                d.showDialog(StrutsUIMessages.ERROR, e.getMessage(), new String[]{StrutsUIMessages.OK}, null, 1);
                Thread.currentThread().setContextClassLoader(c);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(c);
        }
    }

    public String generateAction(XModelObject action, String baseClass, String imports, boolean genProps, boolean genGlobal, boolean genLocal) {
        int version = StrutsGenerator.getVersion(action);
        String templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(action)) + ACTION_PATH;
        String className = action.getAttributeValue("type");
        if (!this.checkClassName(className)) {
            return null;
        }
        String targetPath = new Path(String.valueOf(className.replace('.', '/')) + ".java").toOSString();
        File source = new File(this.root, targetPath);
        if (!this.checkOverwrite(source, action.getModel())) {
            return null;
        }
        targetPath = source.getAbsolutePath();
        ArrayList<PropertyDescriptor> properties = this.getProperties(action, genProps);
        ArrayList<String> globalForwards = null;
        if (genGlobal) {
            globalForwards = new ArrayList<String>();
            XModelObject[] globs = action.getParent().getParent().getChildByPath("global-forwards").getChildren();
            int i = 0;
            while (i < globs.length) {
                String name = globs[i].getAttributeValue("name");
                globalForwards.add(name);
                ++i;
            }
        }
        ArrayList<String> localForwards = null;
        if (genLocal) {
            localForwards = new ArrayList<String>();
            XModelObject[] locs = action.getChildren("StrutsForward" + version);
            int i = 0;
            while (i < locs.length) {
                String name = locs[i].getAttributeValue("name");
                localForwards.add(name);
                ++i;
            }
        }
        Map<String, Object> parameters = this.getParameters(action, className, baseClass, properties);
        if (genGlobal) {
            parameters.put("globalForwards", globalForwards);
        }
        if (genLocal) {
            parameters.put("localForwards", localForwards);
        }
        this.executeTemplate(parameters, templatePath, targetPath);
        if (genProps && properties.size() > 0) {
            templatePath = String.valueOf(StrutsGenerator.getVersionTemplateBase(action)) + ACTION_CONFIG_PATH;
            className = this.executePropertiesTemplate(parameters, action.getModel(), templatePath, className);
        }
        return className;
    }

    private List<MethodDescriptor> getConstructors(XModelObject object, String baseClass) {
        ArrayList<MethodDescriptor> constructors = new ArrayList<MethodDescriptor>();
        try {
            IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)EclipseResourceUtil.getProject((XModelObject)object));
            IType type = EclipseJavaUtil.findType((IJavaProject)javaProject, (String)baseClass);
            if (type == null) {
                return constructors;
            }
            IJavaElement[] ch = type.getChildren();
            int i = 0;
            while (i < ch.length) {
                IMethod method;
                if (ch[i] instanceof IMethod && (method = (IMethod)ch[i]).isConstructor()) {
                    constructors.add(new MethodDescriptor(method));
                }
                ++i;
            }
        }
        catch (JavaModelException ex) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)ex);
        }
        return constructors;
    }

    private boolean checkClassName(String className) {
        if (className.length() == 0 || !className.startsWith(this.basePackage)) {
            return false;
        }
        int i = 0;
        while (i < EXCLUDE_PKGS.length) {
            if (className.startsWith(EXCLUDE_PKGS[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkOverwrite(File source, XModel model) {
        if (source.exists()) {
            switch (this.overwrite) {
                case 1: {
                    return true;
                }
                case 0: {
                    return false;
                }
                case 2: {
                    ServiceDialog d = model.getService();
                    int r = d.showDialog(StrutsUIMessages.GENERATE_JAVA_CODE, NLS.bind((String)StrutsUIMessages.FILE_ALREADY_EXISTS, (Object)source.getAbsolutePath()), new String[]{StrutsUIMessages.ABORT, StrutsUIMessages.CONTINUE}, null, 2);
                    return r == 1;
                }
            }
        }
        return true;
    }

    public static int getVersion(XModelObject object) {
        String entity = object.getModelEntity().getName();
        return entity.endsWith("10") ? 10 : (entity.endsWith("12") ? 12 : 11);
    }

    private static String getVersionTemplateBase(XModelObject object) {
        int v = StrutsGenerator.getVersion(object);
        return v == 10 ? CODEGEN_10 : (v == 11 ? CODEGEN_11 : (v == 12 ? CODEGEN_12 : CODEGEN_11));
    }

    private String getClassName(String fullName) {
        int ind = fullName.lastIndexOf(46);
        return ind > 0 ? fullName.substring(ind + 1) : fullName;
    }

    private String getPackageName(String fullName) {
        if (this.basePackage != null && this.basePackage.length() > 0) {
            return this.basePackage;
        }
        int ind = fullName.lastIndexOf(46);
        return ind > 0 ? fullName.substring(0, ind) : "";
    }

    private Map<String, Object> getParameters(XModelObject o, String className, String baseClass, ArrayList<PropertyDescriptor> properties) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("package", this.getPackageName(className));
        parameters.put("className", this.getClassName(className));
        parameters.put("extends", baseClass);
        if (properties != null) {
            parameters.put("properties", properties);
        }
        return parameters;
    }

    private ArrayList<PropertyDescriptor> getProperties(XModelObject o, boolean genProps) {
        ArrayList<PropertyDescriptor> p = null;
        if (genProps) {
            p = new ArrayList<PropertyDescriptor>();
            XModelObject[] props = o.getChildren("StrutsSetProperty");
            int i = 0;
            while (i < props.length) {
                String name = props[i].getAttributeValue("property");
                p.add(new PropertyDescriptor(name));
                ++i;
            }
        }
        return p;
    }

    private String executePropertiesTemplate(Map<String, Object> parameters, XModel model, String templatePath, String className) {
        className = String.valueOf(className) + "Config";
        parameters.put("className", this.getClassName(className));
        String targetPath = new Path(String.valueOf(className.replace('.', '/')) + ".java").toOSString();
        File source = new File(this.root, targetPath);
        if (!this.checkOverwrite(source, model)) {
            return null;
        }
        targetPath = source.getAbsolutePath();
        this.executeTemplate(parameters, templatePath, targetPath);
        return className;
    }
}

