/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.pv;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.java.handlers.OpenJavaSourceHandler;
import org.jboss.tools.jst.web.project.list.IWebPromptingProvider;
import org.jboss.tools.struts.model.helpers.open.OpenBundleHelper;
import org.jboss.tools.struts.model.helpers.open.OpenFileInWebRoot;
import org.jboss.tools.struts.model.helpers.open.OpenFormBean;
import org.jboss.tools.struts.model.helpers.open.OpenForwardTargetHelper;
import org.jboss.tools.struts.model.helpers.open.OpenKeyHelper;
import org.jboss.tools.struts.model.helpers.open.OpenLinkActionHelper;
import org.jboss.tools.struts.model.helpers.open.OpenLinkForwardHelper;
import org.jboss.tools.struts.model.helpers.open.OpenLinkPageHelper;
import org.jboss.tools.struts.model.helpers.open.OpenObjectByPath;
import org.jboss.tools.struts.model.helpers.open.OpenProperty;
import org.jboss.tools.struts.model.helpers.open.OpenResourceParameterHelper;
import org.jboss.tools.struts.model.helpers.open.OpenTagLib;
import org.jboss.tools.struts.model.helpers.open.OpenValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsPromptingProvider
implements IWebPromptingProvider {
    public boolean isSupporting(String id) {
        return id != null && id.startsWith("struts");
    }

    public List<Object> getList(XModel model, String id, String prefix, Properties properties) {
        try {
            return this.getListInternal(model, id, prefix, properties);
        }
        catch (Exception e) {
            if (properties != null) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                properties.setProperty("error", e.getMessage());
            }
            return EMPTY_LIST;
        }
    }

    private List<Object> getListInternal(XModel model, String id, String prefix, Properties properties) throws Exception {
        String error = null;
        if ("struts.open.bundle".equals(id)) {
            String bundle = properties.getProperty("bundle");
            if (bundle == null) {
                bundle = prefix;
            }
            OpenBundleHelper h = new OpenBundleHelper();
            error = h.run(model, bundle);
        } else if ("struts.open.parameter".equals(id)) {
            String name = properties.getProperty("name");
            OpenResourceParameterHelper h = new OpenResourceParameterHelper();
            error = h.run(model, name);
        } else if ("struts.open.key".equals(id)) {
            String bundle = properties.getProperty("bundle");
            String key = properties.getProperty("key");
            String locale = properties.getProperty("locale");
            OpenKeyHelper h = new OpenKeyHelper();
            error = h.run(model, bundle, key, locale);
        } else if ("struts.open.link.forward".equals(id)) {
            String forward = prefix;
            OpenLinkForwardHelper h = new OpenLinkForwardHelper();
            error = h.run(model, forward);
        } else if ("struts.open.link.page".equals(id)) {
            String page = prefix;
            if (page != null && new File(page).isFile()) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(page);
                return l;
            }
            IFile f = (IFile)properties.get("file");
            OpenLinkPageHelper h = new OpenLinkPageHelper();
            error = h.run(f, model, page);
        } else if ("struts.open.link.action".equals(id)) {
            String action = prefix;
            String module = properties.getProperty("module");
            OpenLinkActionHelper h = new OpenLinkActionHelper();
            error = h.run(model, action, module);
        } else if ("struts.open.property".equals(id)) {
            String action = properties.getProperty("action");
            String type = properties.getProperty("type");
            String property = prefix;
            if (property == null) {
                property = properties.getProperty("property");
            }
            OpenProperty h = new OpenProperty();
            error = h.run(model, type, action, property);
        } else if ("struts.open.action.mapping".equals(id)) {
            String action = prefix;
            if (action == null) {
                action = properties.getProperty("action");
            }
            OpenLinkActionHelper h = new OpenLinkActionHelper();
            error = h.run(model, action, null);
        } else if ("struts.open.form.bean".equals(id)) {
            String name = prefix;
            String formProperty = properties.getProperty("property");
            OpenFormBean h = new OpenFormBean();
            error = h.run(model, name, formProperty);
        } else if ("struts.open.forward.path".equals(id)) {
            String objectPath = properties.getProperty("model-path");
            String pathValue = prefix;
            IFile f = (IFile)properties.get("file");
            OpenForwardTargetHelper h = new OpenForwardTargetHelper();
            error = h.run(f, objectPath, pathValue);
        } else if ("struts.open.object.by.path".equals(id)) {
            IFile f = (IFile)properties.get("file");
            String objectPath = properties.getProperty("model-path");
            OpenObjectByPath h = new OpenObjectByPath();
            error = h.run(f, objectPath);
        } else if ("struts.open.file.in.web.root".equals(id)) {
            String path = prefix;
            OpenFileInWebRoot h = new OpenFileInWebRoot();
            error = h.run(model, path);
        } else if ("struts.open.validator".equals(id)) {
            String name = prefix;
            OpenValidator h = new OpenValidator();
            error = h.run(model, name);
        } else if ("struts.open.taglibrary".equals(id)) {
            String uri = prefix;
            String tagName = properties.getProperty("name");
            String attributeName = properties.getProperty("attribute");
            OpenTagLib h = new OpenTagLib();
            error = h.run(model, uri, tagName, attributeName);
        } else if ("struts.open.method".equals(id)) {
            String type = properties.getProperty("type");
            String method = properties.getProperty("name");
            Properties pp = new Properties();
            pp.setProperty("method", method);
            pp.setProperty("ignoreWarning", "true");
            OpenJavaSourceHandler.open((XModel)model, (String)type, (Properties)pp);
            error = pp.getProperty("error");
        }
        if (error != null) {
            throw new Exception(error);
        }
        return EMPTY_LIST;
    }
}

