/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers.adopt;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AWStep;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectContext;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectFinisher;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectStepFolders;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectStepLocation;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectStepModules;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectStepName;

public class AdoptProjectSupport
extends SpecialWizardSupport {
    protected AdoptProjectContext context = new AdoptProjectContext();
    protected AWStep[] steps = this.createSteps();
    protected AdoptProjectFinisher finisher = new AdoptProjectFinisher();
    protected String presetLocation = null;
    protected boolean presetSuccess = false;

    public AdoptProjectSupport() {
        this.context.setSupport(this);
        int i = 0;
        while (i < this.steps.length) {
            this.steps[i].setSupport(this, i);
            ++i;
        }
    }

    protected AWStep[] createSteps() {
        return new AWStep[]{new AdoptProjectStepLocation(), new AdoptProjectStepName(), new AdoptProjectStepModules(), new AdoptProjectStepFolders()};
    }

    public String getTitle() {
        return "Adopt Existing Project - " + this.steps[this.getStepId()].getTitle();
    }

    public void reset() {
        if (this.getProperties() == null) {
            this.p = new Properties();
        }
        this.p.put("context", (Object)this.context);
        this.p.put("canceled", "true");
        this.context.reset();
        int i = 0;
        while (i < this.steps.length) {
            this.steps[i].reset();
            this.steps[i].init();
            ++i;
        }
        this.steps[0].set();
        this.presetLocation = this.p.getProperty("presetWebInfPath");
        if (this.presetLocation != null) {
            this.setAttributeValue(0, "location", this.presetLocation);
            try {
                this.action(NEXT);
            }
            catch (XModelException e) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)e);
                return;
            }
            i = this.presetLocation.lastIndexOf(47);
            String q = this.presetLocation.substring(0, i);
            q = q.substring(q.lastIndexOf(47) + 1);
            this.setAttributeValue(1, "name", q);
            this.setAttributeValue(1, "web.xml location", String.valueOf(this.presetLocation) + "/web.xml");
            this.setAttributeValue(0, "location", this.presetLocation);
            try {
                this.action(NEXT);
            }
            catch (XModelException e) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)e);
                return;
            }
            this.presetSuccess = true;
        }
    }

    public String[] getActionNames(int stepId) {
        String[] stringArray;
        int i = this.getStepId();
        int last = this.steps.length - 1;
        if (this.presetSuccess && i == 2) {
            return new String[]{NEXT, CANCEL};
        }
        if (i == 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = NEXT;
            stringArray = stringArray2;
            stringArray2[1] = CANCEL;
        } else if (i > 0 && i < last) {
            String[] stringArray3 = new String[3];
            stringArray3[0] = BACK;
            stringArray3[1] = NEXT;
            stringArray = stringArray3;
            stringArray3[2] = CANCEL;
        } else if (i == last) {
            String[] stringArray4 = new String[3];
            stringArray4[0] = BACK;
            stringArray4[1] = FINISH;
            stringArray = stringArray4;
            stringArray4[2] = CANCEL;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.steps[this.getStepId()].onNext();
            this.finish();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setStepId(-1);
            this.getProperties().setProperty("canceled", "true");
            this.setFinished(true);
        } else if (NEXT.equals(name)) {
            int i = this.steps[this.getStepId()].onNext();
            this.setStepId(i);
            this.steps[i].set();
        } else if (BACK.equals(name)) {
            this.setStepId(this.getStepId() - 1);
        } else {
            this.steps[this.getStepId()].action(name);
        }
    }

    protected void finish() throws XModelException {
        Properties properties = this.getProperties();
        if ("yes".equals(properties.getProperty("returnData"))) {
            properties.put("context", (Object)this.context);
        } else {
            this.finisher.execute();
        }
        this.p.put("canceled", "false");
    }

    public String getMessage(int stepId) {
        return this.steps[stepId].getMessage();
    }

    public String getAttributeMessage(int stepId, String attrname) {
        return this.steps[stepId].getAttributeMessage(attrname);
    }

    public String getStepImplementingClass(int stepId) {
        if (stepId == 0) {
            return "org.jboss.tools.struts.ui.wizard.adopt.AdoptProjectStepLocationView";
        }
        if (stepId == 2) {
            return "org.jboss.tools.struts.ui.wizard.adopt.AdoptProjectStepModulesView";
        }
        return super.getStepImplementingClass(stepId);
    }

    AdoptProjectContext context() {
        return this.context;
    }
}

