/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.builder;

import java.util.Map;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PMDBuilder
extends IncrementalProjectBuilder {
    public static final Logger log;
    public static final String PMD_BUILDER = "net.sourceforge.pmd.eclipse.plugin.pmdBuilder";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.builder.PMDBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        log.info((Object)"Incremental builder activated");
        try {
            if (n == 9) {
                log.debug((Object)"Auto build requested.");
                this.buildAuto(iProgressMonitor);
            } else if (n == 6) {
                log.debug((Object)"Full build requested.");
                this.buildFull(iProgressMonitor);
            } else if (n == 10) {
                log.debug((Object)"Incremental build requested.");
                this.buildIncremental(iProgressMonitor);
            } else {
                log.warn((Object)("This kind of build is not supported : " + n));
            }
        }
        catch (CommandException commandException) {
            throw new CoreException((IStatus)new Status(4, PMDPlugin.getDefault().getBundle().getSymbolicName(), 0, commandException.getMessage(), (Throwable)commandException));
        }
        log.info((Object)"Build done.");
        return null;
    }

    private void buildAuto(IProgressMonitor iProgressMonitor) throws CommandException {
        this.buildIncremental(iProgressMonitor);
    }

    private void buildFull(IProgressMonitor iProgressMonitor) throws CommandException {
        IProject iProject = this.getProject();
        if (iProject != null) {
            this.processProjectFiles(iProject, iProgressMonitor);
        }
    }

    private void buildIncremental(IProgressMonitor iProgressMonitor) throws CommandException {
        IProject iProject = this.getProject();
        if (iProject != null) {
            IResourceDelta iResourceDelta = this.getDelta(iProject);
            if (iResourceDelta != null && iResourceDelta.getAffectedChildren().length != 0) {
                ReviewCodeCmd reviewCodeCmd = new ReviewCodeCmd();
                reviewCodeCmd.setResourceDelta(iResourceDelta);
                reviewCodeCmd.setTaskMarker(false);
                reviewCodeCmd.setMonitor(iProgressMonitor);
                reviewCodeCmd.performExecute();
            } else {
                log.info((Object)"No change reported. Performing no build");
            }
        }
    }

    private void processProjectFiles(IProject iProject, IProgressMonitor iProgressMonitor) throws CommandException {
        ReviewCodeCmd reviewCodeCmd = new ReviewCodeCmd();
        reviewCodeCmd.addResource((IResource)iProject);
        reviewCodeCmd.setTaskMarker(false);
        reviewCodeCmd.setMonitor(iProgressMonitor);
        reviewCodeCmd.performExecute();
    }
}

