/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import name.herlin.command.AbstractProcessableCommand;
import name.herlin.command.CommandException;
import name.herlin.command.CommandProcessor;
import name.herlin.command.Timer;
import name.herlin.command.UnsetInputPropertiesException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JobCommandProcessor
implements CommandProcessor {
    private static final Logger log;
    private final Map jobs = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.JobCommandProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void processCommand(final AbstractProcessableCommand abstractProcessableCommand) throws CommandException {
        log.debug((Object)("Begining job command " + abstractProcessableCommand.getName()));
        if (!abstractProcessableCommand.isReadyToExecute()) {
            throw new UnsetInputPropertiesException();
        }
        Job job = new Job(abstractProcessableCommand.getName()){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    if (abstractProcessableCommand instanceof AbstractDefaultCommand) {
                        ((AbstractDefaultCommand)abstractProcessableCommand).setMonitor(iProgressMonitor);
                    }
                    Timer timer = new Timer();
                    abstractProcessableCommand.execute();
                    timer.stop();
                    PMDPlugin.getDefault().logInformation("Command " + abstractProcessableCommand.getName() + " excecuted in " + timer.getDuration() + "ms");
                }
                catch (CommandException commandException) {
                    PMDPlugin.getDefault().logError("Error executing command " + abstractProcessableCommand.getName(), commandException);
                }
                return Status.OK_STATUS;
            }
        };
        if (abstractProcessableCommand instanceof AbstractDefaultCommand) {
            job.setUser(((AbstractDefaultCommand)abstractProcessableCommand).isUserInitiated());
        }
        job.schedule();
        this.addJob(abstractProcessableCommand, job);
        log.debug((Object)("Ending job command " + abstractProcessableCommand.getName()));
    }

    public void waitCommandToFinish(AbstractProcessableCommand abstractProcessableCommand) throws CommandException {
        Job job = (Job)this.jobs.get(abstractProcessableCommand);
        if (job != null) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                throw new CommandException(interruptedException);
            }
        }
    }

    private void addJob(AbstractProcessableCommand abstractProcessableCommand, Job job) {
        this.jobs.put(abstractProcessableCommand, job);
        Iterator iterator = this.jobs.keySet().iterator();
        while (iterator.hasNext()) {
            AbstractProcessableCommand abstractProcessableCommand2 = (AbstractProcessableCommand)iterator.next();
            Job job2 = (Job)this.jobs.get(abstractProcessableCommand2);
            if (job2 != null && job2.getResult() == null) continue;
            this.jobs.remove(abstractProcessableCommand2);
        }
    }
}

