/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.properties.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkingSet;

public class ProjectPropertiesImpl
implements IProjectProperties {
    private static final Logger log;
    private static final String PROJECT_RULESET_FILE = ".ruleset";
    private final IProjectPropertiesManager projectPropertiesManager;
    private final IProject project;
    private boolean needRebuild;
    private boolean pmdEnabled;
    private boolean ruleSetStoredInProject;
    private String ruleSetFile;
    private RuleSet projectRuleSet;
    private IWorkingSet projectWorkingSet;
    private boolean includeDerivedFiles;
    private boolean violationsAsErrors = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.properties.impl.ProjectPropertiesImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public ProjectPropertiesImpl(IProject iProject, IProjectPropertiesManager iProjectPropertiesManager) {
        this.project = iProject;
        this.projectPropertiesManager = iProjectPropertiesManager;
        this.projectRuleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isPmdEnabled() {
        return this.pmdEnabled;
    }

    public void setPmdEnabled(boolean bl) {
        log.debug((Object)("Enable PMD for project " + this.project.getName() + ": " + this.pmdEnabled));
        if (this.pmdEnabled != bl) {
            this.pmdEnabled = bl;
            this.needRebuild |= bl;
        }
    }

    public RuleSet getProjectRuleSet() throws PropertiesException {
        return this.cloneRuleSet();
    }

    public void setProjectRuleSet(RuleSet ruleSet) throws PropertiesException {
        log.debug((Object)("Set a rule set for project " + this.project.getName()));
        if (ruleSet == null) {
            throw new PropertiesException("Setting a project rule set to null");
        }
        this.needRebuild |= !this.projectRuleSet.getRules().equals(ruleSet.getRules());
        this.projectRuleSet = ruleSet;
    }

    public boolean isRuleSetStoredInProject() {
        return this.ruleSetStoredInProject;
    }

    public void setRuleSetStoredInProject(boolean bl) throws PropertiesException {
        log.debug((Object)("Set rule set stored in project for project " + this.project.getName() + ": " + bl));
        this.needRebuild |= this.ruleSetStoredInProject ^ bl;
        this.ruleSetStoredInProject = bl;
        if (this.ruleSetStoredInProject && !this.isRuleSetFileExist()) {
            throw new PropertiesException("The project ruleset file cannot be found for project " + this.project.getName());
        }
    }

    public String getRuleSetFile() {
        if (this.ruleSetFile == null || this.ruleSetFile.trim().length() == 0) {
            return PROJECT_RULESET_FILE;
        }
        return this.ruleSetFile;
    }

    public void setRuleSetFile(String string) throws PropertiesException {
        log.debug((Object)("Set rule set file for project " + this.project.getName() + ": " + string));
        this.needRebuild |= this.ruleSetFile == null || !string.equals(string);
        this.ruleSetFile = string;
        if (this.ruleSetStoredInProject && !this.isRuleSetFileExist()) {
            throw new PropertiesException("The project ruleset file cannot be found for project " + this.project.getName());
        }
    }

    public IWorkingSet getProjectWorkingSet() {
        return this.projectWorkingSet;
    }

    public void setProjectWorkingSet(IWorkingSet iWorkingSet) {
        log.debug((Object)("Set working set for project " + this.project.getName() + ": " + (iWorkingSet == null ? "none" : iWorkingSet.getName())));
        this.needRebuild |= this.projectWorkingSet == null ? iWorkingSet != null : !this.projectWorkingSet.equals(iWorkingSet);
        this.projectWorkingSet = iWorkingSet;
    }

    public boolean isNeedRebuild() {
        log.debug((Object)("Query if project " + this.project.getName() + " need rebuild : " + (this.pmdEnabled && this.needRebuild)));
        log.debug((Object)("   PMD Enabled = " + this.pmdEnabled));
        log.debug((Object)("   Project need rebuild = " + this.needRebuild));
        return this.pmdEnabled && this.needRebuild;
    }

    public void setNeedRebuild(boolean bl) {
        log.debug((Object)("Set if rebuild is needed for project " + this.project.getName() + ": " + bl));
        this.needRebuild = bl;
    }

    public final boolean isRuleSetFileExist() {
        return this.getResolvedRuleSetFile().exists();
    }

    public File getResolvedRuleSetFile() {
        File file;
        boolean bl;
        IFile iFile = this.project.getFile(this.getRuleSetFile());
        boolean bl2 = bl = iFile.exists() && iFile.isAccessible();
        if (bl) {
            file = new File(iFile.getLocation().toOSString());
            if (!file.exists()) {
                file = new File(this.getRuleSetFile());
            }
        } else {
            file = new File(this.getRuleSetFile());
        }
        return file;
    }

    public void createDefaultRuleSetFile() throws PropertiesException {
        log.info((Object)("Create a default rule set file for project " + this.project.getName()));
        try {
            IRuleSetWriter iRuleSetWriter = PMDPlugin.getDefault().getRuleSetWriter();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            iRuleSetWriter.write(byteArrayOutputStream, this.projectRuleSet);
            byteArrayOutputStream.close();
            IFile iFile = this.project.getFile(PROJECT_RULESET_FILE);
            if (iFile.exists() && iFile.isAccessible()) {
                throw new PropertiesException("Project ruleset file already exists");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            iFile.create((InputStream)byteArrayInputStream, true, null);
            byteArrayInputStream.close();
        }
        catch (WriterException writerException) {
            throw new PropertiesException(writerException);
        }
        catch (IOException iOException) {
            throw new PropertiesException(iOException);
        }
        catch (CoreException coreException) {
            throw new PropertiesException(coreException);
        }
    }

    public boolean isIncludeDerivedFiles() {
        return this.includeDerivedFiles;
    }

    public void setIncludeDerivedFiles(boolean bl) {
        log.debug((Object)("Set if derived files should be included: " + bl));
        this.needRebuild |= this.includeDerivedFiles ^ bl;
        this.includeDerivedFiles = bl;
    }

    public void sync() throws PropertiesException {
        log.info((Object)("Commit properties for project " + this.project.getName()));
        this.projectPropertiesManager.storeProjectProperties(this);
    }

    private RuleSet cloneRuleSet() {
        RuleSet ruleSet = new RuleSet();
        Iterator iterator = this.projectRuleSet.getRules().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            ruleSet.addRule(rule);
        }
        ruleSet.addExcludePatterns(this.projectRuleSet.getExcludePatterns());
        ruleSet.addIncludePatterns(this.projectRuleSet.getIncludePatterns());
        return ruleSet;
    }

    public boolean violationsAsErrors() throws PropertiesException {
        return this.violationsAsErrors;
    }

    public void setViolationsAsErrors(boolean bl) throws PropertiesException {
        log.debug((Object)("Set to handle violations as errors: " + bl));
        this.needRebuild |= this.violationsAsErrors ^ bl;
        this.violationsAsErrors = bl;
    }
}

