/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;

public class DataflowMethodRecord {
    private final IMethod method;
    private final SimpleNode node;

    public DataflowMethodRecord(IMethod iMethod, SimpleNode simpleNode) {
        if (iMethod == null) {
            throw new IllegalArgumentException("javaMethod cannot be null");
        }
        if (simpleNode == null) {
            throw new IllegalArgumentException("pmdMethod cannot be null");
        }
        this.method = iMethod;
        this.node = simpleNode;
    }

    public SimpleNode getPMDMethod() {
        return this.node;
    }

    public IMethod getJavaMethod() {
        return this.method;
    }

    public IResource getResource() {
        return this.method.getResource();
    }

    public IMarker[] getMarkers() {
        IMarker[] iMarkerArray;
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        try {
            if (this.method.getResource().isAccessible()) {
                iMarkerArray = this.method.getResource().findMarkers("net.sourceforge.pmd.eclipse.plugin.pmdDFAMarker", true, 2);
                int n = 0;
                while (n < iMarkerArray.length) {
                    if (this.markerIsValid(iMarkerArray[n]) && !this.markerIsInList(iMarkerArray[n], arrayList)) {
                        arrayList.add(iMarkerArray[n]);
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), coreException);
        }
        iMarkerArray = new IMarker[arrayList.size()];
        arrayList.toArray(iMarkerArray);
        return iMarkerArray;
    }

    private Object[] getMarkerAttributes(IMarker iMarker) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(iMarker.getAttribute("message", ""));
        int n = iMarker.getAttribute("lineNumber", 0);
        int n2 = iMarker.getAttribute("line2", 0);
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        arrayList.add(new Integer(n));
        arrayList.add(new Integer(n2));
        arrayList.add(iMarker.getAttribute("variable", ""));
        return arrayList.toArray();
    }

    private boolean markerIsValid(IMarker iMarker) {
        boolean bl = false;
        Object[] objectArray = this.getMarkerAttributes(iMarker);
        int n = (Integer)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (n >= this.node.getBeginLine() && n2 <= this.node.getEndLine()) {
            bl = true;
            int n3 = 0;
            while (n3 < objectArray.length && bl) {
                if (objectArray[n3] instanceof String && ((String)objectArray[n3]).equals("")) {
                    bl = false;
                } else if (objectArray[n3] instanceof Integer && (Integer)objectArray[n3] == 0) {
                    bl = false;
                }
                ++n3;
            }
        }
        return bl;
    }

    private boolean markerIsInList(IMarker iMarker, List list) {
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            Object[] objectArray = this.getMarkerAttributes(iMarker);
            int n = 0;
            while (n < list.size() && !bl) {
                Object[] objectArray2 = this.getMarkerAttributes((IMarker)list.get(n));
                boolean bl2 = true;
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    if (objectArray[n2] instanceof String && !((String)objectArray[n2]).equalsIgnoreCase((String)objectArray2[n2])) {
                        bl2 = false;
                    } else if (objectArray[n2] instanceof Integer && !((Integer)objectArray[n2]).equals((Integer)objectArray2[n2])) {
                        bl2 = false;
                    }
                    ++n2;
                }
                if (bl2) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }
}

