/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RuleSetSelectionDialog
extends Dialog {
    protected Combo inputCombo;
    private Button referenceButton;
    private Button copyButton;
    private String importedRuleSetName;
    private final RuleSet[] ruleSets;
    private final String[] ruleSetNames;
    private RuleSet selectedRuleSet;
    private boolean importByReference;

    public RuleSetSelectionDialog(Shell shell) {
        super(shell);
        Set set = PMDPlugin.getDefault().getRuleSetManager().getRegisteredRuleSets();
        TreeSet treeSet = new TreeSet(new Comparator(){

            public boolean equals(Object object) {
                return false;
            }

            public int compare(Object object, Object object2) {
                RuleSet ruleSet = (RuleSet)object;
                RuleSet ruleSet2 = (RuleSet)object2;
                return ruleSet.getName().compareToIgnoreCase(ruleSet2.getName());
            }
        });
        treeSet.addAll(set);
        this.ruleSets = new RuleSet[treeSet.size()];
        this.ruleSetNames = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.ruleSets[n] = (RuleSet)iterator.next();
            this.ruleSetNames[n] = this.ruleSets[n].getName();
            ++n;
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = this.buildLabel(composite2, this.getMessage("preference.rulesetselection.label.enter_ruleset"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        this.inputCombo = this.buildInputCombo(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.inputCombo.setLayoutData((Object)gridData);
        this.buildBrowseButton(composite2);
        this.referenceButton = this.buildReferenceButton(composite2);
        this.copyButton = this.buildCopyButton(composite2);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.copyButton.setLayoutData((Object)gridData);
        this.getShell().setText(this.getMessage("preference.ruleset.dialog.title"));
        return composite2;
    }

    private Label buildLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        return label;
    }

    private Combo buildInputCombo(Composite composite) {
        Combo combo = new Combo(composite, 0);
        combo.setItems(this.ruleSetNames);
        combo.setText("");
        combo.setToolTipText(this.getMessage("preference.rulesetselection.tooltip.ruleset"));
        return combo;
    }

    private Button buildBrowseButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(this.getMessage("preference.rulesetselection.button.browse"));
        button.setEnabled(true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(RuleSetSelectionDialog.this.getShell(), 4096);
                String string = fileDialog.open();
                if (string != null) {
                    RuleSetSelectionDialog.this.inputCombo.setText(string);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        return button;
    }

    private Button buildReferenceButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.rulesetselection.button.reference"));
        button.setSelection(true);
        this.importByReference = true;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RuleSetSelectionDialog.this.copyButton.setSelection(false);
                RuleSetSelectionDialog.this.importByReference = true;
            }
        });
        return button;
    }

    private Button buildCopyButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("preference.rulesetselection.button.copy"));
        button.setSelection(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RuleSetSelectionDialog.this.referenceButton.setSelection(false);
                RuleSetSelectionDialog.this.importByReference = false;
            }
        });
        return button;
    }

    public String getImportedRuleSetName() {
        return this.importedRuleSetName;
    }

    public RuleSet getSelectedRuleSet() {
        return this.selectedRuleSet;
    }

    public boolean isImportByReference() {
        return this.importByReference;
    }

    protected void okPressed() {
        int n = this.inputCombo.getSelectionIndex();
        if (n == -1) {
            this.importedRuleSetName = this.inputCombo.getText();
            if (!this.importedRuleSetName.equals("")) {
                try {
                    RuleSetFactory ruleSetFactory = new RuleSetFactory();
                    this.selectedRuleSet = ruleSetFactory.createRuleSets(this.importedRuleSetName).getAllRuleSets()[0];
                }
                catch (RuleSetNotFoundException ruleSetNotFoundException) {
                    PMDPlugin.getDefault().showError(this.getMessage("message.error.ruleset_not_found"), ruleSetNotFoundException);
                }
            }
        } else {
            this.selectedRuleSet = this.ruleSets[n];
        }
        super.okPressed();
    }

    private String getMessage(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

