/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.properties;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IWorkingSet;

public class UpdateProjectPropertiesCmd
extends AbstractDefaultCommand {
    private static final long serialVersionUID = 1L;
    private IProject project;
    private boolean pmdEnabled;
    private IWorkingSet projectWorkingSet;
    private RuleSet projectRuleSet;
    private boolean ruleSetStoredInProject;
    private String ruleSetFile;
    private boolean needRebuild;
    private boolean ruleSetFileExists;
    private boolean includeDerivedFiles;
    private boolean violationsAsErrors = true;

    public UpdateProjectPropertiesCmd() {
        this.setReadOnly(false);
        this.setOutputProperties(true);
        this.setTerminated(false);
        this.setName("UpdateProjectProperties");
        this.setDescription("Update a project PMD specific properties.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws CommandException {
        try {
            try {
                IProjectProperties iProjectProperties = PMDPlugin.getDefault().loadProjectProperties(this.project);
                iProjectProperties.setPmdEnabled(this.pmdEnabled);
                iProjectProperties.setProjectRuleSet(this.projectRuleSet);
                iProjectProperties.setProjectWorkingSet(this.projectWorkingSet);
                iProjectProperties.setRuleSetStoredInProject(this.ruleSetStoredInProject);
                iProjectProperties.setRuleSetFile(this.ruleSetFile);
                iProjectProperties.setIncludeDerivedFiles(this.includeDerivedFiles);
                iProjectProperties.setViolationsAsErrors(this.violationsAsErrors);
                iProjectProperties.sync();
                this.needRebuild = iProjectProperties.isNeedRebuild();
                this.ruleSetFileExists = !iProjectProperties.isRuleSetFileExist();
            }
            catch (PropertiesException propertiesException) {
                throw new CommandException(propertiesException.getMessage(), propertiesException);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.setTerminated(true);
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        this.setTerminated(true);
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public void setPmdEnabled(boolean bl) {
        this.pmdEnabled = bl;
    }

    public void setProjectRuleSet(RuleSet ruleSet) {
        this.projectRuleSet = ruleSet;
    }

    public void setProjectWorkingSet(IWorkingSet iWorkingSet) {
        this.projectWorkingSet = iWorkingSet;
    }

    public void setRuleSetStoredInProject(boolean bl) {
        this.ruleSetStoredInProject = bl;
    }

    public void setRuleSetFile(String string) {
        this.ruleSetFile = string;
    }

    public void setIncludeDerivedFiles(boolean bl) {
        this.includeDerivedFiles = bl;
    }

    public void setViolationsAsErrors(boolean bl) {
        this.violationsAsErrors = bl;
    }

    public boolean isNeedRebuild() {
        return this.needRebuild;
    }

    public boolean isRuleSetFileExists() {
        return this.ruleSetFileExists;
    }

    public void reset() {
        this.setProject(null);
        this.setPmdEnabled(false);
        this.setProjectRuleSet(null);
        this.setRuleSetStoredInProject(false);
        this.setRuleSetFile(null);
        this.setIncludeDerivedFiles(false);
        this.setViolationsAsErrors(false);
        this.setTerminated(false);
    }

    public boolean isReadyToExecute() {
        return this.project != null && this.projectRuleSet != null;
    }
}

