/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlinePage;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class ViolationOverviewDoubleClickListener
implements IDoubleClickListener {
    private final ViolationOverview overview;

    public ViolationOverviewDoubleClickListener(ViolationOverview violationOverview) {
        this.overview = violationOverview;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof PackageRecord) {
            this.doubleClickToPackageRecord((PackageRecord)object);
        } else if (object instanceof FileRecord) {
            this.doubleClickToFileRecord((FileRecord)object);
        } else if (object instanceof MarkerRecord) {
            this.doubleClickToMarkerRecord((MarkerRecord)object);
        } else if (object instanceof FileToMarkerRecord) {
            this.doubleClickToFileToMarkerRecord((FileToMarkerRecord)object);
        }
    }

    private void doubleClickToFileToMarkerRecord(FileToMarkerRecord fileToMarkerRecord) {
        this.openEditor((IFile)fileToMarkerRecord.getResource());
        final IMarker[] iMarkerArray = fileToMarkerRecord.findMarkers();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViolationOverviewDoubleClickListener.this.selectMarkerInOutline(iMarkerArray);
            }
        });
    }

    private void doubleClickToMarkerRecord(MarkerRecord markerRecord) {
        IMarker[] iMarkerArray;
        switch (this.overview.getShowType()) {
            case 1: 
            case 2: {
                this.openEditor((IFile)markerRecord.getResource());
                iMarkerArray = markerRecord.findMarkers();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ViolationOverviewDoubleClickListener.this.selectMarkerInOutline(iMarkerArray);
                    }
                });
            }
        }
        iMarkerArray = this.overview.getViewer();
        if (iMarkerArray.getExpandedState((Object)markerRecord)) {
            iMarkerArray.collapseToLevel((Object)markerRecord, 1);
        } else if (this.overview.getShowType() == 3) {
            iMarkerArray.expandToLevel((Object)markerRecord, 1);
        }
    }

    private void doubleClickToFileRecord(FileRecord fileRecord) {
        TreeViewer treeViewer = this.overview.getViewer();
        if (treeViewer.getExpandedState((Object)fileRecord)) {
            treeViewer.collapseToLevel((Object)fileRecord, 1);
        } else {
            treeViewer.expandToLevel((Object)fileRecord, 1);
        }
        this.openEditor((IFile)fileRecord.getResource());
    }

    private void doubleClickToPackageRecord(PackageRecord packageRecord) {
        TreeViewer treeViewer = this.overview.getViewer();
        if (treeViewer.getExpandedState((Object)packageRecord)) {
            treeViewer.collapseToLevel((Object)packageRecord, -1);
        } else {
            treeViewer.expandToLevel((Object)packageRecord, 1);
        }
    }

    private void openEditor(IFile iFile) {
        try {
            IDE.openEditor((IWorkbenchPage)this.overview.getSite().getPage(), (IFile)iFile);
        }
        catch (PartInitException partInitException) {
            PMDPlugin.getDefault().logError("message.error.view_exception" + this.toString(), partInitException);
        }
    }

    private void selectMarkerInOutline(IMarker[] iMarkerArray) {
        try {
            IWorkbenchPage iWorkbenchPage = this.overview.getSite().getPage();
            ViolationOutline violationOutline = (ViolationOutline)iWorkbenchPage.findView("net.sourceforge.pmd.eclipse.ui.views.violationOutline");
            if (violationOutline == null) {
                violationOutline = (ViolationOutline)iWorkbenchPage.showView("net.sourceforge.pmd.eclipse.ui.views.violationOutline");
            }
            if (violationOutline.getCurrentPage() instanceof ViolationOutlinePage) {
                ViolationOutlinePage violationOutlinePage = (ViolationOutlinePage)violationOutline.getCurrentPage();
                TableItem[] tableItemArray = violationOutlinePage.getTableViewer().getTable().getItems();
                violationOutlinePage.getTableViewer().getTable().deselectAll();
                int n = 0;
                while (n < iMarkerArray.length) {
                    int n2 = 0;
                    while (n2 < tableItemArray.length) {
                        if (tableItemArray[n2].getData() instanceof IMarker && iMarkerArray[n].equals(tableItemArray[n2].getData())) {
                            violationOutlinePage.getTableViewer().getTable().select(n2);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (PartInitException partInitException) {
            PMDPlugin.getDefault().logError("message.error.view_exception" + this.toString(), partInitException);
        }
    }
}

