/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.launch.IConsoleConfigurationLaunchConstants;
import org.hibernate.util.xpl.StringHelper;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.InputSource;

public class ProjectUtils {
    private ProjectUtils() {
    }

    public static boolean toggleHibernateOnProject(IProject project, boolean enable, String defaultConsoleName) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            node.putBoolean("hibernate3.enabled", enable);
            node.put("default.configuration", defaultConsoleName);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.ProjectUtils_could_not_save_changes_to_preferences, e);
                return false;
            }
        } else {
            return false;
        }
        try {
            if (enable) {
                return ProjectUtils.addProjectNature(project, "org.hibernate.eclipse.console.hibernateNature", (IProgressMonitor)new NullProgressMonitor());
            }
            return ProjectUtils.removeProjectNature(project, "org.hibernate.eclipse.console.hibernateNature", new NullProgressMonitor());
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage(String.valueOf(HibernateConsoleMessages.ProjectUtils_could_not_activate_hibernate_nature_on_project) + project.getName(), ce);
            HibernateConsolePlugin.getDefault().log(ce.getStatus());
            return false;
        }
    }

    public static boolean addProjectNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature(nature)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = nature;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
            return true;
        }
        monitor.worked(1);
        return false;
    }

    public static boolean removeProjectNature(IProject project, String nature, NullProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (project.hasNature(nature)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length - 1];
            int i = 0;
            int j = 0;
            while (i < natures.length) {
                if (!natures[i].equals(nature)) {
                    newNatures[j++] = natures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)monitor);
            return true;
        }
        monitor.worked(1);
        return false;
    }

    public static IJavaProject findJavaProject(IEditorPart part) {
        if (part != null) {
            return ProjectUtils.findJavaProject(part.getEditorInput());
        }
        return null;
    }

    public static IJavaProject findJavaProject(IEditorInput input) {
        if (input != null && input instanceof IFileEditorInput) {
            IFile file = null;
            IProject project = null;
            IJavaProject jProject = null;
            IFileEditorInput fileInput = (IFileEditorInput)input;
            file = fileInput.getFile();
            project = file.getProject();
            jProject = JavaCore.create((IProject)project);
            return jProject;
        }
        return null;
    }

    public static IProject findProject(String name) {
        if (StringHelper.isEmpty((String)name)) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(name);
        return project;
    }

    public static IJavaProject findJavaProject(String name) {
        IProject project = ProjectUtils.findProject(name);
        if (project != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IProject findProject(ConsoleConfiguration consoleConfiguration) {
        if (consoleConfiguration != null) {
            try {
                ILaunchConfiguration launchConfiguration = LaunchHelper.findHibernateLaunchConfig(consoleConfiguration.getName());
                if (launchConfiguration != null) {
                    String projName = launchConfiguration.getAttribute(IConsoleConfigurationLaunchConstants.PROJECT_NAME, "");
                    return ProjectUtils.findProject(projName);
                }
            }
            catch (CoreException e1) {
                HibernateConsolePlugin.getDefault().log(e1);
            }
        }
        return null;
    }

    public static IJavaProject findJavaProject(ConsoleConfiguration consoleConfiguration) {
        IProject project = ProjectUtils.findProject(consoleConfiguration);
        if (project != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean exists(IFile f) {
        int type;
        if (!(f instanceof File)) {
            return false;
        }
        File file = (File)f;
        ResourceInfo info = file.getResourceInfo(false, false);
        int flags = file.getFlags(info);
        return flags != -1 && ((type = ResourceInfo.getType((int)flags)) == 1 || type == 2 || type == 4);
    }

    private static boolean updateCollection(ArrayList<IProject> projects, IProject project) {
        if (project == null) {
            return false;
        }
        Iterator<IProject> it = projects.iterator();
        while (it.hasNext()) {
            if (!project.equals((Object)it.next())) continue;
            return false;
        }
        projects.add(project);
        return true;
    }

    public static IJavaProject[] findJavaProjects(ConsoleConfiguration consoleConfiguration) {
        ConsoleConfigurationPreferences ccp = consoleConfiguration.getPreferences();
        URL[] classPathURLs = new URL[]{};
        if (ccp != null) {
            classPathURLs = ccp.getCustomClassPathURLS();
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IFile file = null;
        int i = 0;
        while (i < classPathURLs.length) {
            IPath path = Path.fromOSString((String)classPathURLs[i].getFile());
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (file == null || !ProjectUtils.exists(file)) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            }
            if (file != null && ProjectUtils.exists(file)) {
                ProjectUtils.updateCollection(projects, file.getProject());
            }
            ++i;
        }
        ProjectUtils.updateCollection(projects, ProjectUtils.findProject(consoleConfiguration));
        ArrayList<IJavaProject> res = new ArrayList<IJavaProject>();
        Iterator<IProject> it = projects.iterator();
        while (it.hasNext()) {
            res.add(JavaCore.create((IProject)it.next()));
        }
        return res.toArray(new IJavaProject[0]);
    }

    public static CompilationUnit getCompilationUnit(ICompilationUnit source, boolean bindings) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        parser.setResolveBindings(bindings);
        CompilationUnit result = (CompilationUnit)parser.createAST(null);
        return result;
    }

    public static ICompilationUnit findCompilationUnit(IJavaProject javaProject, String fullyQualifiedName) {
        IType lwType = ProjectUtils.findType(javaProject, fullyQualifiedName);
        if (lwType != null) {
            return lwType.getCompilationUnit();
        }
        return null;
    }

    public static IType findType(IJavaProject javaProject, String fullyQualifiedName) {
        IType lwType = null;
        try {
            lwType = javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException javaModelException) {}
        return lwType;
    }

    public static String getParentTypename(IJavaProject proj, String fullyQualifiedName) {
        String res = null;
        ICompilationUnit icu = ProjectUtils.findCompilationUnit(proj, fullyQualifiedName);
        if (icu == null) {
            return res;
        }
        CompilationUnit cu = ProjectUtils.getCompilationUnit(icu, true);
        if (cu == null) {
            return res;
        }
        List types = cu.types();
        int i = 0;
        while (i < types.size() && res == null) {
            ITypeBinding tb;
            TypeDeclaration td;
            Type superType;
            Object obj = types.get(i);
            if (obj instanceof TypeDeclaration && (superType = (td = (TypeDeclaration)obj).getSuperclassType()) != null && (tb = superType.resolveBinding()) != null && tb.getJavaElement() instanceof SourceType) {
                SourceType sourceT = (SourceType)tb.getJavaElement();
                try {
                    res = sourceT.getFullyQualifiedParameterizedName();
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("JavaModelException: ", e);
                }
            }
            ++i;
        }
        return res;
    }

    public static String[] availablePersistenceUnits(IJavaProject javaProject) {
        Document doc;
        block22: {
            if (javaProject == null || javaProject.getResource() == null) {
                return new String[0];
            }
            IPath projPathFull = javaProject.getResource().getLocation();
            IPath projPath = javaProject.getPath();
            IPath path = javaProject.readOutputLocation().append("META-INF/persistence.xml");
            path = path.makeRelativeTo(projPath);
            path = projPathFull.append(path);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (!ProjectUtils.exists(file)) {
                return new String[0];
            }
            InputStream is = null;
            doc = null;
            try {
                is = file.getContents();
                SAXReader saxReader = new SAXReader();
                doc = saxReader.read(new InputSource(is));
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("CoreException: ", e);
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {}
                break block22;
            }
            catch (DocumentException e) {
                try {
                    HibernateConsolePlugin.getDefault().logErrorMessage("DocumentException: ", e);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {}
                break block22;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (doc == null || doc.getRootElement() == null) {
            return new String[0];
        }
        Iterator it = doc.getRootElement().elements("persistence-unit").iterator();
        ArrayList<String> res = new ArrayList<String>();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            res.add(el.attributeValue("name"));
        }
        return res.toArray(new String[0]);
    }
}

