/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsListener;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.console.workbench.DeferredContentProvider;

public class KnownConfigurationsProvider
extends DeferredContentProvider
implements KnownConfigurationsListener,
IResourceChangeListener,
IPropertyChangeListener {
    private TreeViewer tv;

    public KnownConfigurationsProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 5);
    }

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        KnownConfigurations newz;
        KnownConfigurations old;
        super.inputChanged(v, oldInput, newInput);
        this.tv = (TreeViewer)v;
        if (oldInput != null && oldInput instanceof KnownConfigurations && (old = (KnownConfigurations)oldInput) != null) {
            old.removeConfigurationListener((KnownConfigurationsListener)this);
        }
        if (newInput != null && newInput instanceof KnownConfigurations && (newz = (KnownConfigurations)newInput) != null) {
            newz.addConsoleConfigurationListener((KnownConfigurationsListener)this);
        }
    }

    public void dispose() {
    }

    public void configurationAdded(ConsoleConfiguration root) {
        this.refreshTree();
    }

    private void refreshTree() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                KnownConfigurationsProvider.this.tv.refresh();
            }
        };
        this.tv.getControl().getDisplay().syncExec(runnable);
    }

    public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
        if (forUpdate) {
            this.refreshTree();
        }
    }

    @Override
    protected IWorkbenchAdapter getAdapter(Object o) {
        if (o instanceof IAdaptable) {
            return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(IWorkbenchAdapter.class);
        }
        return (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(o, IWorkbenchAdapter.class);
    }

    public void sessionFactoryBuilt(ConsoleConfiguration ccfg, SessionFactory builtFactory) {
    }

    public void sessionFactoryClosing(ConsoleConfiguration configuration, SessionFactory closingFactory) {
        this.refreshTree(configuration);
    }

    public void configurationReset(ConsoleConfiguration ccfg) {
        this.refreshTree(ccfg);
    }

    private void refreshTree(final ConsoleConfiguration configuration) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                KnownConfigurationsProvider.this.tv.collapseToLevel((Object)configuration, -1);
                KnownConfigurationsProvider.this.tv.refresh((Object)configuration);
            }
        });
    }

    public void configurationBuilt(ConsoleConfiguration ccfg) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)new KnownConfigurationsVisitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_CLOSED") || event.getProperty().equals("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_DELETED")) {
            this.refreshTree();
        }
    }

    class KnownConfigurationsVisitor
    implements IResourceDeltaVisitor {
        KnownConfigurationsVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x4000) != 0) {
                IProject project;
                if (delta.getResource() instanceof IProject && (project = (IProject)delta.getResource()).isOpen()) {
                    try {
                        ILaunchConfiguration[] configs = LaunchHelper.findProjectRelatedHibernateLaunchConfigs(project.getName());
                        if (configs.length > 0) {
                            KnownConfigurationsProvider.this.refreshTree();
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        KnownConfigurationsProvider.this.refreshTree();
                    }
                }
                return false;
            }
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        try {
                            ILaunchConfiguration[] configs = LaunchHelper.findProjectRelatedHibernateLaunchConfigs(project.getName());
                            if (configs.length <= 0) break;
                            KnownConfigurationsProvider.this.refreshTree();
                            break;
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            KnownConfigurationsProvider.this.refreshTree();
                        }
                    }
                }
                return false;
            }
            return true;
        }
    }
}

