/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.hibernate.eclipse.console.HibernateConsoleMessages;

public class ConsoleConfigurationNamingStrategyChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private String fNewNamingStrategyName;
    private String fOldNamingStrategyTypeName;

    public ConsoleConfigurationNamingStrategyChange(ILaunchConfiguration launchConfiguration, String newNamingStrategyName) throws CoreException {
        this.fLaunchConfiguration = launchConfiguration;
        this.fNewNamingStrategyName = newNamingStrategyName;
        this.fOldNamingStrategyTypeName = this.fLaunchConfiguration.getAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", null);
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }

    public String getName() {
        return HibernateConsoleMessages.ConsoleConfigurationITypeRenameParticipant_update_names;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.fLaunchConfiguration.getWorkingCopy();
        String oldNamingStrategyTypeName = this.fOldNamingStrategyTypeName;
        wc.setAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", this.fNewNamingStrategyName);
        this.fLaunchConfiguration = wc.doSave();
        return new ConsoleConfigurationNamingStrategyChange(this.fLaunchConfiguration, oldNamingStrategyTypeName);
    }
}

