/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;

public class RegisterArchivesJob
extends Job {
    private IProject[] projects;
    private Runnable callback;

    public RegisterArchivesJob(IProject[] projects, Runnable callback) {
        super(ArchivesCoreMessages.RegisterProject);
        this.projects = projects;
        this.callback = callback;
    }

    protected IStatus run(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.projects.length) {
            try {
                ArchivesModel.instance().registerProject(this.projects[i].getLocation(), monitor);
            }
            catch (ArchivesModelException ame) {
                Status status = new Status(4, "org.jboss.ide.eclipse.archives.core", ame.getMessage(), (Throwable)ame);
                return status;
            }
            ++i;
        }
        this.callback.run();
        return Status.OK_STATUS;
    }
}

