/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class PruneUnconditionalExceptionThrowerEdges
implements EdgeTypes {
    private static final boolean DEBUG;
    private static final boolean DEBUG_DIFFERENCES;
    private static final String UNCONDITIONAL_THROWER_METHOD_NAMES;
    private MethodGen methodGen;
    private CFG cfg;
    private ConstantPoolGen cpg;
    private TypeDataflow typeDataflow;
    private AnalysisContext analysisContext;
    private boolean cfgModified;
    private static final Pattern unconditionalThrowerPattern;
    private static final BitSet RETURN_OPCODE_SET;

    public PruneUnconditionalExceptionThrowerEdges(JavaClass javaClass, Method method, MethodGen methodGen, CFG cfg, ConstantPoolGen cpg, TypeDataflow typeDataflow, AnalysisContext analysisContext) {
        this.methodGen = methodGen;
        this.cfg = cfg;
        this.cpg = cpg;
        this.typeDataflow = typeDataflow;
        this.analysisContext = analysisContext;
    }

    public void execute() throws DataflowAnalysisException {
        AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext.getBoolProperty(1)) {
            throw new IllegalStateException("This should not happen");
        }
        boolean foundInexact = false;
        HashSet<Edge> deletedEdgeSet = new HashSet<Edge>();
        if (DEBUG) {
            System.out.println("PruneUnconditionalExceptionThrowerEdges: examining " + SignatureConverter.convertMethodSignature(this.methodGen));
        }
        Iterator<BasicBlock> i = this.cfg.blockIterator();
        while (i.hasNext()) {
            Edge fallThrough;
            boolean newResult;
            InstructionHandle instructionHandle;
            Instruction exceptionThrower;
            BasicBlock basicBlock = i.next();
            if (!basicBlock.isExceptionThrower() || !((exceptionThrower = (instructionHandle = basicBlock.getExceptionThrower()).getInstruction()) instanceof InvokeInstruction)) continue;
            InvokeInstruction inv = (InvokeInstruction)exceptionThrower;
            boolean foundThrower = false;
            boolean foundNonThrower = false;
            boolean isExact = true;
            XMethod primaryXMethod = XFactory.createXMethod(inv, this.cpg);
            String methodName = primaryXMethod.getName();
            boolean matches = unconditionalThrowerPattern.matcher(methodName).matches();
            if (DEBUG) {
                System.out.println("Checking '" + methodName + "' is " + matches);
            }
            if (matches) {
                if (DEBUG) {
                    System.out.println("\tmatched for " + instructionHandle + " : " + primaryXMethod);
                }
                foundThrower = true;
            } else {
                if (inv instanceof INVOKEINTERFACE) continue;
                if (inv instanceof INVOKESTATIC) {
                    foundThrower = this.isUnconditionalThrower(primaryXMethod);
                } else {
                    String className = inv.getClassName(this.cpg);
                    if (DEBUG) {
                        System.out.println("\tlooking up method for " + instructionHandle + " : " + primaryXMethod);
                    }
                    Location loc = new Location(instructionHandle, basicBlock);
                    TypeFrame typeFrame = (TypeFrame)this.typeDataflow.getFactAtLocation(loc);
                    Set<XMethod> targetSet = null;
                    try {
                        String methodSig;
                        if (className.startsWith("[") || !(methodSig = inv.getSignature(this.cpg)).endsWith("V") && !methodSig.endsWith("Exception;") && !methodSig.endsWith("Error;")) continue;
                        targetSet = Hierarchy2.resolveMethodCallTargets(inv, typeFrame, this.cpg);
                        for (XMethod xMethod : targetSet) {
                            boolean isUnconditionalThrower;
                            if (DEBUG) {
                                System.out.println("\tFound " + xMethod);
                            }
                            if (!(xMethod.isFinal() || xMethod.isStatic() || xMethod.isPrivate())) {
                                try {
                                    isExact = false;
                                    XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, xMethod.getClassDescriptor());
                                    if (xClass.isAbstract()) {
                                        continue;
                                    }
                                }
                                catch (CheckedAnalysisException e) {
                                    AnalysisContext.logError("Unable to resolve class for " + xMethod, e);
                                }
                            }
                            if (isUnconditionalThrower = this.isUnconditionalThrower(xMethod)) {
                                foundThrower = true;
                                if (!DEBUG) continue;
                                System.out.println("Found thrower");
                                continue;
                            }
                            foundNonThrower = true;
                            if (!DEBUG) continue;
                            System.out.println("Found non thrower");
                        }
                    }
                    catch (ClassNotFoundException e) {
                        this.analysisContext.getLookupFailureCallback().reportMissingClass(e);
                    }
                }
            }
            if (!(newResult = foundThrower && !foundNonThrower)) continue;
            if (!isExact) {
                foundInexact = true;
            }
            if ((fallThrough = this.cfg.getOutgoingEdgeWithType(basicBlock, 0)) == null) continue;
            if (DEBUG) {
                System.out.println("\tREMOVING normal return for: " + primaryXMethod);
            }
            deletedEdgeSet.add(fallThrough);
        }
        if (!deletedEdgeSet.isEmpty()) {
            this.cfgModified = true;
            if (foundInexact) {
                this.cfg.setFlag(32);
            }
            for (Edge edge : deletedEdgeSet) {
                this.cfg.removeEdge(edge);
            }
        }
    }

    private boolean isUnconditionalThrower(XMethod xMethod) {
        return xMethod.isUnconditionalThrower() && !xMethod.isUnsupported() && !xMethod.isSynthetic();
    }

    @Deprecated
    public static Boolean doesMethodUnconditionallyThrowException(XMethod xMethod, JavaClass javaClass, Method method) {
        return PruneUnconditionalExceptionThrowerEdges.doesMethodUnconditionallyThrowException(xMethod);
    }

    public static boolean doesMethodUnconditionallyThrowException(XMethod xMethod) {
        return xMethod.isUnconditionalThrower();
    }

    public boolean wasCFGModified() {
        return this.cfgModified;
    }

    static {
        Pattern p;
        DEBUG = SystemProperties.getBoolean("cfg.prune.throwers.debug");
        DEBUG_DIFFERENCES = SystemProperties.getBoolean("cfg.prune.throwers.differences.debug");
        UNCONDITIONAL_THROWER_METHOD_NAMES = SystemProperties.getProperty("findbugs.unconditionalThrower", " ").replace(',', '|');
        RETURN_OPCODE_SET = new BitSet();
        RETURN_OPCODE_SET.set(176);
        RETURN_OPCODE_SET.set(172);
        RETURN_OPCODE_SET.set(173);
        RETURN_OPCODE_SET.set(175);
        RETURN_OPCODE_SET.set(174);
        RETURN_OPCODE_SET.set(177);
        try {
            p = Pattern.compile(UNCONDITIONAL_THROWER_METHOD_NAMES);
            if (DEBUG) {
                System.out.println("Pattern is '" + p + "'");
                System.out.println(p.matcher("showInvalidPage").matches());
            }
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error compiling unconditional thrower pattern " + UNCONDITIONAL_THROWER_METHOD_NAMES, e);
            p = Pattern.compile(" ");
        }
        unconditionalThrowerPattern = p;
    }
}

