/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ch;

import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.InheritanceGraphVisitor;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;

public abstract class OverriddenMethodsVisitor
implements InheritanceGraphVisitor {
    private XMethod xmethod;

    public OverriddenMethodsVisitor(XMethod xmethod) {
        assert (!xmethod.isStatic());
        this.xmethod = xmethod;
    }

    public XMethod getXmethod() {
        return this.xmethod;
    }

    public boolean visitClass(ClassDescriptor classDescriptor, XClass xclass) {
        assert (xclass != null);
        boolean bridged = this.xmethod.isBridged();
        String methodSignature = bridged && !classDescriptor.equals(this.xmethod.getClassDescriptor()) ? this.xmethod.getBridgeSignature() : this.xmethod.getSignature();
        XMethod xm = xclass.findMethod(this.xmethod.getName(), methodSignature, false);
        if (xm == null && bridged && xclass.isInterface()) {
            xm = xclass.findMethod(this.xmethod.getName(), this.xmethod.getSignature(), false);
        }
        if (xm != null) {
            return this.visitOverriddenMethod(xm) || bridged;
        }
        return true;
    }

    public boolean visitEdge(ClassDescriptor sourceDesc, XClass source, ClassDescriptor targetDesc, XClass target) {
        return target != null;
    }

    protected abstract boolean visitOverriddenMethod(XMethod var1);
}

