/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.type.FieldStoreType;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.Collections;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFrameModelingVisitor
extends AbstractFrameModelingVisitor<Type, TypeFrame>
implements Constants,
Debug {
    private static final ObjectType COLLECTION_TYPE = ObjectTypeFactory.getInstance("java.util.Collection");
    private ValueNumberDataflow valueNumberDataflow;
    private boolean instanceOfFollowedByBranch;
    private ReferenceType instanceOfType;
    private ValueNumber instanceOfValueNumber;
    private FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
    private FieldStoreTypeDatabase database;
    boolean sawEffectiveInstanceOf;
    boolean previousWasEffectiveInstanceOf;

    public TypeFrameModelingVisitor(ConstantPoolGen cpg) {
        super(cpg);
    }

    public void setValueNumberDataflow(ValueNumberDataflow valueNumberDataflow) {
        this.valueNumberDataflow = valueNumberDataflow;
    }

    public boolean isInstanceOfFollowedByBranch() {
        return this.instanceOfFollowedByBranch;
    }

    public Type getInstanceOfType() {
        return this.instanceOfType;
    }

    public ValueNumber getInstanceOfValueNumber() {
        return this.instanceOfValueNumber;
    }

    public void setFieldStoreTypeDatabase(FieldStoreTypeDatabase database) {
        this.database = database;
    }

    @Override
    public Type getDefaultValue() {
        return TypeFrame.getBottomType();
    }

    @Override
    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        this.instanceOfFollowedByBranch = false;
        this.sawEffectiveInstanceOf = false;
        super.analyzeInstruction(ins);
        this.previousWasEffectiveInstanceOf = this.sawEffectiveInstanceOf;
    }

    public void startBasicBlock() {
        this.instanceOfType = null;
        this.instanceOfValueNumber = null;
    }

    protected void consumeStack(Instruction ins) {
        ConstantPoolGen cpg = this.getCPG();
        TypeFrame frame = (TypeFrame)this.getFrame();
        int numWordsConsumed = ins.consumeStack(cpg);
        if (numWordsConsumed == -2) {
            throw new InvalidBytecodeException("Unpredictable stack consumption for " + ins);
        }
        try {
            while (numWordsConsumed-- > 0) {
                frame.popValue();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow for " + ins + ": " + e.getMessage());
        }
    }

    protected void pushValue(Type type) {
        TypeFrame frame = (TypeFrame)this.getFrame();
        if (type.getType() == 11) {
            frame.pushValue((Type)Type.LONG);
            frame.pushValue(TypeFrame.getLongExtraType());
        } else if (type.getType() == 7) {
            frame.pushValue((Type)Type.DOUBLE);
            frame.pushValue(TypeFrame.getDoubleExtraType());
        } else {
            frame.pushValue(type);
        }
    }

    protected void pushReturnType(InvokeInstruction ins) {
        ConstantPoolGen cpg = this.getCPG();
        Type type = ins.getType(cpg);
        if (type.getType() != 12) {
            this.pushValue(type);
        }
    }

    @Override
    public void modelNormalInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced) {
        if (VERIFY_INTEGRITY && numWordsProduced > 0) {
            throw new InvalidBytecodeException("missing visitor method for " + ins);
        }
        super.modelNormalInstruction(ins, numWordsConsumed, numWordsProduced);
    }

    @Override
    public void visitATHROW(ATHROW obj) {
    }

    @Override
    public void visitACONST_NULL(ACONST_NULL obj) {
        this.pushValue(TypeFrame.getNullType());
    }

    @Override
    public void visitDCONST(DCONST obj) {
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitFCONST(FCONST obj) {
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitICONST(ICONST obj) {
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLCONST(LCONST obj) {
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitLDC(LDC obj) {
        this.pushValue(obj.getType(this.getCPG()));
    }

    @Override
    public void visitLDC2_W(LDC2_W obj) {
        this.pushValue(obj.getType(this.getCPG()));
    }

    @Override
    public void visitBIPUSH(BIPUSH obj) {
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitSIPUSH(SIPUSH obj) {
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitGETSTATIC(GETSTATIC obj) {
        this.modelFieldLoad((FieldInstruction)obj);
    }

    @Override
    public void visitGETFIELD(GETFIELD obj) {
        this.modelFieldLoad((FieldInstruction)obj);
    }

    public void modelFieldLoad(FieldInstruction obj) {
        Type loadType;
        this.consumeStack((Instruction)obj);
        Type originalLoadType = loadType = obj.getType(this.getCPG());
        try {
            XField xfield = Hierarchy.findXField(obj, this.getCPG());
            if (xfield != null) {
                FieldStoreType property;
                if (this.database != null && loadType instanceof ReferenceType && (property = (FieldStoreType)this.database.getProperty(xfield.getFieldDescriptor())) != null) {
                    loadType = property.getLoadType((ReferenceType)loadType);
                }
                OpcodeStack.Item summary = this.fieldSummary.getSummary(xfield);
                if (xfield.isFinal() && summary.isNull()) {
                    this.pushValue(TypeFrame.getNullType());
                    return;
                }
                if (loadType == originalLoadType && summary != null && !summary.getSignature().equals("Ljava/lang/Object;")) {
                    loadType = Type.getType((String)summary.getSignature());
                }
                Field field = Hierarchy.findField(xfield.getClassName(), xfield.getName());
                String signature = null;
                for (Attribute a : field.getAttributes()) {
                    if (!(a instanceof Signature)) continue;
                    signature = ((Signature)a).getSignature();
                    break;
                }
                if (signature != null && loadType instanceof ObjectType) {
                    loadType = GenericUtilities.merge(GenericUtilities.getType(signature), (ObjectType)loadType);
                }
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.pushValue(loadType);
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        String methodName = obj.getMethodName(this.cpg);
        String signature = obj.getSignature(this.cpg);
        String className = obj.getClassName(this.cpg);
        if (methodName.equals("asList") && className.equals("java.util.Arrays") && signature.equals("([Ljava/lang/Object;)Ljava/util/List;")) {
            this.consumeStack((Instruction)obj);
            Type returnType = Type.getType((String)"Ljava/util/Arrays$ArrayList;");
            this.pushValue(returnType);
            return;
        }
        this.consumeStack((Instruction)obj);
        this.pushReturnType((InvokeInstruction)obj);
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.consumeStack((Instruction)obj);
        this.pushReturnType((InvokeInstruction)obj);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        if (this.handleToArray((InvokeInstruction)obj)) {
            return;
        }
        this.consumeStack((Instruction)obj);
        this.pushReturnType((InvokeInstruction)obj);
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        TypeFrame frame = (TypeFrame)this.getFrame();
        String methodName = obj.getMethodName(this.cpg);
        String signature = obj.getSignature(this.cpg);
        String className = obj.getClassName(this.cpg);
        if (methodName.equals("cast") && className.equals("java.lang.Class")) {
            try {
                Type resultType = frame.popValue();
                frame.popValue();
                frame.pushValue(resultType);
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("oops", e);
            }
            return;
        }
        if (methodName.equals("entrySet") && signature.equals("()Ljava/util/Set;") && className.endsWith("Map")) {
            ObjectType mapType;
            Type argType;
            try {
                argType = frame.popValue();
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("oops", e);
                return;
            }
            if (argType instanceof GenericObjectType) {
                GenericObjectType genericArgType = (GenericObjectType)argType;
                mapType = GenericUtilities.getType("java.util.Map$Entry", genericArgType.getParameters());
            } else {
                mapType = (ObjectType)Type.getType((String)"Ljava/util/Map$Entry;");
            }
            GenericObjectType entrySetType = GenericUtilities.getType("java.util.Set", Collections.singletonList(mapType));
            frame.pushValue((Type)entrySetType);
            return;
        }
        if (methodName.equals("isInstance") && className.equals("java.lang.Class") && this.valueNumberDataflow != null) {
            try {
                String c;
                ValueNumber stackValue;
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                if (vnaFrame.isValid() && (stackValue = (ValueNumber)vnaFrame.getStackValue(1)).hasFlag(4) && (c = this.valueNumberDataflow.getClassName(stackValue)) != null) {
                    Type type;
                    if (c.charAt(0) != '[' && !c.endsWith(";")) {
                        c = "L" + c.replace('.', '/') + ";";
                    }
                    if ((type = Type.getType((String)c)) instanceof ReferenceType) {
                        this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                        this.instanceOfType = (ReferenceType)type;
                        this.sawEffectiveInstanceOf = true;
                    }
                }
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
        if (methodName.equals("initCause") && signature.equals("(Ljava/lang/Throwable;)Ljava/lang/Throwable;") && className.endsWith("Exception")) {
            try {
                frame.popValue();
                return;
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Ooops", e);
            }
        }
        if (this.handleToArray((InvokeInstruction)obj)) {
            return;
        }
        this.consumeStack((Instruction)obj);
        this.pushReturnType((InvokeInstruction)obj);
    }

    private boolean handleToArray(InvokeInstruction obj) {
        try {
            TypeFrame frame = (TypeFrame)this.getFrame();
            Type topValue = (Type)frame.getTopValue();
            if (obj.getName(this.getCPG()).equals("toArray")) {
                ReferenceType target = obj.getReferenceType(this.getCPG());
                String signature = obj.getSignature(this.getCPG());
                if (signature.equals("([Ljava/lang/Object;)[Ljava/lang/Object;") && this.isCollection(target)) {
                    boolean topIsExact = frame.isExact(frame.getStackLocation(0));
                    Type resultType = frame.popValue();
                    frame.popValue();
                    frame.pushValue(resultType);
                    frame.setExact(frame.getStackLocation(0), topIsExact);
                    return true;
                }
                if (signature.equals("()[Ljava/lang/Object;") && this.isCollection(target) && !topValue.getSignature().equals("Ljava/util/Arrays$ArrayList;")) {
                    this.consumeStack((Instruction)obj);
                    this.pushReturnType(obj);
                    frame.setExact(frame.getStackLocation(0), true);
                    return true;
                }
            }
            return false;
        }
        catch (DataflowAnalysisException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    @Override
    public void handleStoreInstruction(StoreInstruction obj) {
        int numConsumed = obj.consumeStack(this.cpg);
        if (numConsumed == 1) {
            try {
                boolean isExact = this.isTopOfStackExact();
                TypeFrame frame = (TypeFrame)this.getFrame();
                int index = obj.getIndex();
                Type value = frame.popValue();
                frame.setValue(index, value);
                frame.setExact(index, isExact);
            }
            catch (DataflowAnalysisException e) {
                throw new InvalidBytecodeException(e.toString());
            }
        } else {
            super.handleStoreInstruction(obj);
        }
    }

    @Override
    public void handleLoadInstruction(LoadInstruction obj) {
        int numProduced = obj.produceStack(this.cpg);
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production");
        }
        if (numProduced != 1) {
            super.handleLoadInstruction(obj);
            return;
        }
        int index = obj.getIndex();
        TypeFrame frame = (TypeFrame)this.getFrame();
        Type value = (Type)frame.getValue(index);
        boolean isExact = frame.isExact(index);
        frame.pushValue(value);
        if (isExact) {
            this.setTopOfStackIsExact();
        }
    }

    private boolean isCollection(ReferenceType target) throws ClassNotFoundException {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        return subtypes2.isSubtype(target, (ReferenceType)COLLECTION_TYPE);
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
        try {
            Type t = ((TypeFrame)this.getFrame()).popValue();
            if (t instanceof NullType) {
                this.pushValue(t);
            } else {
                this.pushValue(obj.getType(this.getCPG()));
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow for " + obj + ": " + e.getMessage());
        }
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF obj) {
        if (this.valueNumberDataflow != null) {
            try {
                Type type;
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                if (vnaFrame.isValid() && (type = obj.getType(this.getCPG())) instanceof ReferenceType) {
                    this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                    this.instanceOfType = (ReferenceType)type;
                    this.sawEffectiveInstanceOf = true;
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitIFNULL(IFNULL obj) {
        if (this.valueNumberDataflow != null) {
            try {
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                if (vnaFrame.isValid()) {
                    this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                    this.instanceOfType = NullType.instance();
                    this.instanceOfFollowedByBranch = true;
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        this.consumeStack((Instruction)obj);
    }

    @Override
    public void visitIFNONNULL(IFNONNULL obj) {
        if (this.valueNumberDataflow != null) {
            try {
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getFactAtLocation(this.getLocation());
                if (vnaFrame.isValid()) {
                    this.instanceOfValueNumber = (ValueNumber)vnaFrame.getTopValue();
                    this.instanceOfType = NullType.instance();
                    this.instanceOfFollowedByBranch = true;
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        this.consumeStack((Instruction)obj);
    }

    @Override
    public void visitFCMPL(FCMPL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitFCMPG(FCMPG obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitDCMPL(DCMPL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitDCMPG(DCMPG obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLCMP(LCMP obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitD2F(D2F obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitD2I(D2I obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitD2L(D2L obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitF2D(F2D obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitF2I(F2I obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitF2L(F2L obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitI2B(I2B obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.BYTE);
    }

    @Override
    public void visitI2C(I2C obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.CHAR);
    }

    @Override
    public void visitI2D(I2D obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitI2F(I2F obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitI2L(I2L obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitI2S(I2S obj) {
    }

    @Override
    public void visitL2D(L2D obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitL2F(L2F obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitL2I(L2I obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitIAND(IAND obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLAND(LAND obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitIOR(IOR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLOR(LOR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitIXOR(IXOR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLXOR(LXOR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitISHR(ISHR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitIUSHR(IUSHR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLSHR(LSHR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitLUSHR(LUSHR obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitISHL(ISHL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLSHL(LSHL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitDADD(DADD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitFADD(FADD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitIADD(IADD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLADD(LADD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitDSUB(DSUB obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitDUP(DUP obj) {
        try {
            TypeFrame frame = (TypeFrame)this.getFrame();
            boolean isExact = this.isTopOfStackExact();
            Type value = frame.popValue();
            frame.pushValue(value);
            if (isExact) {
                this.setTopOfStackIsExact();
            }
            frame.pushValue(value);
            if (isExact) {
                this.setTopOfStackIsExact();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    @Override
    public void visitFSUB(FSUB obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitISUB(ISUB obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLSUB(LSUB obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitDMUL(DMUL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitFMUL(FMUL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitIMUL(IMUL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLMUL(LMUL obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitDDIV(DDIV obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitFDIV(FDIV obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitIDIV(IDIV obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLDIV(LDIV obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitDREM(DREM obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitFREM(FREM obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitIREM(IREM obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLREM(LREM obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitIINC(IINC obj) {
    }

    @Override
    public void visitDNEG(DNEG obj) {
    }

    @Override
    public void visitFNEG(FNEG obj) {
    }

    @Override
    public void visitINEG(INEG obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLNEG(LNEG obj) {
    }

    @Override
    public void visitARRAYLENGTH(ARRAYLENGTH obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitAALOAD(AALOAD obj) {
        TypeFrame frame = (TypeFrame)this.getFrame();
        try {
            frame.popValue();
            Type arrayType = frame.popValue();
            if (arrayType instanceof ArrayType) {
                ArrayType arr = (ArrayType)arrayType;
                this.pushValue(arr.getElementType());
            } else {
                this.pushValue(TypeFrame.getBottomType());
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Stack underflow: " + e.getMessage());
        }
    }

    @Override
    public void visitBALOAD(BALOAD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.BYTE);
    }

    @Override
    public void visitCALOAD(CALOAD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.CHAR);
    }

    @Override
    public void visitDALOAD(DALOAD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.DOUBLE);
    }

    @Override
    public void visitFALOAD(FALOAD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.FLOAT);
    }

    @Override
    public void visitIALOAD(IALOAD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.INT);
    }

    @Override
    public void visitLALOAD(LALOAD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.LONG);
    }

    @Override
    public void visitSALOAD(SALOAD obj) {
        this.consumeStack((Instruction)obj);
        this.pushValue((Type)Type.SHORT);
    }

    @Override
    public void visitNEW(NEW obj) {
        this.pushValue(obj.getType(this.getCPG()));
        this.setTopOfStackIsExact();
    }

    @Override
    public void visitNEWARRAY(NEWARRAY obj) {
        this.consumeStack((Instruction)obj);
        Type elementType = obj.getType();
        this.pushValue(elementType);
        this.setTopOfStackIsExact();
    }

    @Override
    public void visitANEWARRAY(ANEWARRAY obj) {
        this.consumeStack((Instruction)obj);
        Type elementType = obj.getType(this.getCPG());
        this.pushValue((Type)new ArrayType(elementType, 1));
        this.setTopOfStackIsExact();
    }

    @Override
    public void visitMULTIANEWARRAY(MULTIANEWARRAY obj) {
        this.consumeStack((Instruction)obj);
        Type elementType = obj.getType(this.getCPG());
        this.pushValue(elementType);
        this.setTopOfStackIsExact();
    }

    private void setTopOfStackIsExact() {
        TypeFrame frame = (TypeFrame)this.getFrame();
        frame.setExact(frame.getNumSlots() - 1, true);
    }

    private boolean isTopOfStackExact() {
        TypeFrame frame = (TypeFrame)this.getFrame();
        return frame.isExact(frame.getNumSlots() - 1);
    }

    @Override
    public void visitJSR(JSR obj) {
        this.pushValue((Type)ReturnaddressType.NO_TARGET);
    }

    @Override
    public void visitJSR_W(JSR_W obj) {
        this.pushValue((Type)ReturnaddressType.NO_TARGET);
    }

    @Override
    public void visitRET(RET obj) {
    }

    @Override
    public void visitIFEQ(IFEQ obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFEQ(obj);
    }

    @Override
    public void visitIFGT(IFGT obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFGT(obj);
    }

    @Override
    public void visitIFLE(IFLE obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFLE(obj);
    }

    @Override
    public void visitIFNE(IFNE obj) {
        if (this.previousWasEffectiveInstanceOf) {
            this.instanceOfFollowedByBranch = true;
        }
        super.visitIFNE(obj);
    }
}

