/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.impl.ClassFactory;
import java.io.IOException;

public class NestedZipFileCodeBaseLocator
implements ICodeBaseLocator {
    private final ICodeBase parentCodeBase;
    private final String resourceName;

    public NestedZipFileCodeBaseLocator(ICodeBase parentCodeBase, String resourceName) {
        this.parentCodeBase = parentCodeBase;
        this.resourceName = resourceName;
    }

    public ICodeBase getParentCodeBase() {
        return this.parentCodeBase;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ICodeBaseLocator createRelativeCodeBaseLocator(String relativePath) {
        return new NestedZipFileCodeBaseLocator(this.parentCodeBase, relativePath);
    }

    public ICodeBase openCodeBase() throws ResourceNotFoundException, IOException {
        return ClassFactory.createNestedZipFileCodeBase(this);
    }

    public String toString() {
        return "nested:[" + this.parentCodeBase.getCodeBaseLocator() + "]" + this.resourceName;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NestedZipFileCodeBaseLocator other = (NestedZipFileCodeBaseLocator)obj;
        return this.parentCodeBase.equals(other.parentCodeBase) && this.resourceName.equals(other.resourceName);
    }

    public int hashCode() {
        return 7919 * this.parentCodeBase.hashCode() + this.resourceName.hashCode();
    }
}

