/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.UseAnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InconsistentAnnotations
implements Detector,
UseAnnotationDatabase {
    public final TypeQualifierValue nonnullTypeQualifierValue;
    final BugReporter reporter;

    public InconsistentAnnotations(BugReporter reporter) {
        ClassDescriptor nonnullClassDesc = DescriptorFactory.createClassDescriptor(Nonnull.class);
        this.nonnullTypeQualifierValue = TypeQualifierValue.getValue(nonnullClassDesc, null);
        this.reporter = reporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        for (Method method : jclass.getMethods()) {
            XMethod xmethod = XFactory.createXMethod(classContext.getJavaClass(), method);
            ParameterNullnessProperty nonnullParameters = (ParameterNullnessProperty)AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase().getProperty(xmethod.getMethodDescriptor());
            if (nonnullParameters == null) continue;
            for (int p : nonnullParameters.iterable()) {
                TypeQualifierAnnotation directTypeQualifierAnnotation = TypeQualifierApplications.getDirectTypeQualifierAnnotation(xmethod, p, this.nonnullTypeQualifierValue);
                if (directTypeQualifierAnnotation == null || directTypeQualifierAnnotation.when != When.UNKNOWN) continue;
                int paramLocal = xmethod.isStatic() ? p : p + 1;
                this.reporter.reportBug(new BugInstance(this, "NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", 2).addClassAndMethod(jclass, method).add(LocalVariableAnnotation.getParameterLocalVariableAnnotation(method, paramLocal)));
            }
        }
    }

    public void report() {
    }
}

