/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import java.io.File;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ClassPathUtil {
    public static String findCodeBaseInClassPath(@Nonnull String codeBaseName, String classPath) {
        if (classPath == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            File f = new File(t);
            if (!f.getName().equals(codeBaseName)) continue;
            return t;
        }
        return null;
    }

    public static String findCodeBaseInClassPath(Pattern codeBaseNamePattern, String classPath) {
        if (classPath == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            File f = new File(t);
            Matcher m = codeBaseNamePattern.matcher(f.getName());
            if (!m.matches()) continue;
            return t;
        }
        return null;
    }
}

