/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.util.Multiset;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionalMultiset<K> {
    final Map<K, Double> map;

    public FractionalMultiset() {
        this.map = new HashMap<K, Double>();
    }

    public FractionalMultiset(Map<K, Double> map) {
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public int numKeys() {
        return this.map.size();
    }

    public void add(K k, double val) {
        Double v = this.map.get(k);
        if (v == null) {
            this.map.put(k, val);
        } else {
            this.map.put(k, v + val);
        }
    }

    public double getValue(K k) {
        Double v = this.map.get(k);
        if (v == null) {
            return 0.0;
        }
        return v;
    }

    public void turnTotalIntoAverage(Multiset<K> counts) {
        for (Map.Entry<K, Double> e : this.map.entrySet()) {
            int count = counts.getCount(e.getKey());
            if (count == 0) {
                e.setValue(Double.NaN);
                continue;
            }
            e.setValue(e.getValue() / (double)count);
        }
    }

    public Iterable<Map.Entry<K, Double>> entrySet() {
        return this.map.entrySet();
    }

    public Iterable<Map.Entry<K, Double>> entriesInDecreasingOrder() {
        TreeSet<Map.Entry<K, Double>> result = new TreeSet<Map.Entry<K, Double>>(new DecreasingOrderEntryComparator());
        result.addAll(this.map.entrySet());
        return result;
    }

    public Iterable<Map.Entry<K, Double>> entriesInIncreasingOrder() {
        TreeSet<Map.Entry<K, Double>> result = new TreeSet<Map.Entry<K, Double>>(new DecreasingOrderEntryComparator());
        result.addAll(this.map.entrySet());
        return result;
    }

    private static <E> int compareValues(Map.Entry<E, Double> o1, Map.Entry<E, Double> o2) {
        double c2;
        double c1 = o1.getValue();
        if (c1 < (c2 = o2.getValue().doubleValue())) {
            return 1;
        }
        if (c1 > c2) {
            return -1;
        }
        return System.identityHashCode(o1.getKey()) - System.identityHashCode(o2.getKey());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IncreasingOrderEntryComparator<E>
    implements Comparator<Map.Entry<E, Double>>,
    Serializable {
        IncreasingOrderEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<E, Double> o1, Map.Entry<E, Double> o2) {
            return -FractionalMultiset.compareValues(o1, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DecreasingOrderEntryComparator<E>
    implements Comparator<Map.Entry<E, Double>>,
    Serializable {
        DecreasingOrderEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<E, Double> o1, Map.Entry<E, Double> o2) {
            return FractionalMultiset.compareValues(o1, o2);
        }
    }
}

