/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package javax.jms;

/**
 * <P> This exception must be thrown when a provider rejects a user 
 *     name/password submitted by a client. It may also be thrown for any case 
 *     where a security restriction prevents a method from completing.
 **/

public class JMSSecurityException extends JMSException {

  /** Constructs a <CODE>JMSSecurityException</CODE> with the specified 
   *  reason and error code.
   *
   *  @param  reason        a description of the exception
   *  @param  errorCode     a string specifying the vendor-specific
   *                        error code
   *                        
   **/
  public 
  JMSSecurityException(String reason, String errorCode) {
    super(reason, errorCode);
  }

  /** Constructs a <CODE>JMSSecurityException</CODE> with the specified 
   *  reason. The error code defaults to null.
   *
   *  @param  reason        a description of the exception
   **/
  public 
  JMSSecurityException(String reason) {
    super(reason);
  }

}
