/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.jst.web.project.helpers.AbstractWebProjectTemplate;
import org.jboss.tools.jst.web.project.version.ProjectVersions;
import org.jboss.tools.struts.StrutsPreference;
import org.jboss.tools.struts.StrutsVersions;

public class StrutsUtils
extends AbstractWebProjectTemplate {
    static StrutsUtils instance = null;

    public static StrutsUtils getInstance() {
        if (instance == null) {
            instance = new StrutsUtils();
        }
        return instance;
    }

    public String getNatureDir() {
        return "struts";
    }

    public ProjectVersions getProjectVersions() {
        return StrutsVersions.getInstance(this.getProjectTemplatesLocation());
    }

    public String getStrutsSupportTemplatesLocation() {
        return String.valueOf(this.getTemplatesBase()) + "/strutssupport/";
    }

    public String getStrutsSupportTemplatesLocation(String version) {
        return String.valueOf(this.getTemplatesBase()) + "/strutssupport/" + this.getStrutsVersion(version);
    }

    public String[] getTldTemplates(String version) {
        File templateDir = new File(String.valueOf(this.getStrutsSupportTemplatesLocation(version)) + "/tld");
        ArrayList<String> l = new ArrayList<String>();
        File[] fs = templateDir.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isFile() && fs[i].getName().endsWith(".tld")) {
                    l.add(fs[i].getName());
                }
                ++i;
            }
        }
        return l.toArray(new String[0]);
    }

    private String getStrutsVersion(String version) {
        if (version == null) {
            return "1.1";
        }
        return version.indexOf("1.0") >= 0 ? "1.0" : (version.indexOf("1.2") >= 0 ? "1.2" : "1.1");
    }

    public Properties getTldTemplateDefaultProperties(String version) {
        version = this.getStrutsVersion(version);
        String path = "%Options%/Struts Studio/Project/Struts Support/Struts Support " + version;
        XModelObject o = PreferenceModelUtilities.getPreferenceModel().getByPath(path);
        XAttribute[] as = o.getModelEntity().getAttributes();
        Properties p = new Properties();
        int i = 0;
        while (i < as.length) {
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() > 0) {
                p.setProperty(xml, o.getAttributeValue(as[i].getName()));
            }
            ++i;
        }
        return p;
    }

    public String getDefaultVersion() {
        String preference = StrutsPreference.DEFAULT_STRUTS_VERSION.getValue();
        return this.getDefaultVersion(preference);
    }

    public String getDefaultTemplate(String version) {
        String preference = StrutsPreference.DEFAULT_PROJECT_TEMPLATE.getValue();
        return this.getDefaultTemplate(version, preference);
    }

    public void setDefaultTemplate(String template) {
        try {
            StrutsPreference.DEFAULT_PROJECT_TEMPLATE.setValue(template);
        }
        catch (XModelException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String getWizardEntitySuffix() {
        return "Struts";
    }

    protected boolean isSetDefaultAllowed() {
        return true;
    }
}

