/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers.page;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultEditHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageSupport;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;

public class RenamePageHandler
extends DefaultEditHandler {
    static String[] PATH_ATTRIBUTES = new String[]{"path", "include", "forward", "input"};

    public boolean isEnabled(XModelObject object) {
        return object.isObjectEditable() && "page".equals(object.getAttributeValue("type"));
    }

    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        XModelObject existingPage;
        boolean isTile;
        Properties p = RenamePageHandler.extractProperties((XEntityData)this.data[0]);
        String oldpath = object.getAttributeValue("path");
        String path = p.getProperty("path");
        if (path.equals("/")) {
            throw new XModelException(StrutsUIMessages.RenamePageHandler_PathIsNotValid);
        }
        boolean bl = isTile = oldpath != null && !oldpath.startsWith("/");
        if (!isTile && !path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.startsWith("/") && path.indexOf(46) < 0) {
            path = String.valueOf(path) + ".jsp";
        }
        if (oldpath.equals(path)) {
            return;
        }
        XModelObject file = object.getModel().getByPath(oldpath);
        XModelObject newfile = object.getModel().getByPath(path);
        if (file != null && (newfile == null || newfile == file)) {
            XModelObject pf = file.getParent();
            int i = 0;
            while (i == 0 && !file.isObjectEditable()) {
                ServiceDialog d = object.getModel().getService();
                i = d.showDialog(StrutsUIMessages.WARNING, NLS.bind((String)StrutsUIMessages.FILE_IS_READONLY, (Object)oldpath), new String[]{StrutsUIMessages.RETRY, StrutsUIMessages.CANCEL}, null, 2);
            }
            if (i != 0) {
                return;
            }
            String body = file.getAttributeValue("body");
            XModelObject fs = file;
            while (fs.getFileType() != 3) {
                fs = fs.getParent();
            }
            DefaultRemoveHandler.removeFromParent((XModelObject)file);
            ((FolderImpl)pf).save();
            ((FolderImpl)pf).update();
            CreatePageSupport.createFile(fs, path, body);
            pf.getModel().update();
        }
        if ((existingPage = this.findExistingPage(object.getParent(), path)) == null) {
            StrutsProcessHelper.getHelper(object.getParent()).resetPage(object, oldpath, path);
            object.getModel().changeObjectAttribute(object, "path", path);
        }
        RenamePageHandler.changeMatchingAttributesInHierarhy(StrutsProcessStructureHelper.instance.getParentFile(object), oldpath, path);
        if (existingPage != null) {
            object.removeFromParent();
        }
    }

    private XModelObject findExistingPage(XModelObject process, String path) {
        XModelObject[] cs = process.getChildren();
        int i = 0;
        while (i < cs.length) {
            String p;
            String type = cs[i].getAttributeValue("type");
            if (!"forward".equals(type) && path.equals(p = cs[i].getAttributeValue("path"))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    public static void changeMatchingAttributesInHierarhy(XModelObject object, String oldpath, String newpath) throws XModelException {
        RenamePageHandler.changeMatchingAttributes(object, oldpath, newpath);
        XModelObject[] os = object.getChildrenForSave();
        int i = 0;
        while (i < os.length) {
            if (!(object instanceof StrutsProcessImpl)) {
                RenamePageHandler.changeMatchingAttributesInHierarhy(os[i], oldpath, newpath);
            }
            ++i;
        }
    }

    public static void changeMatchingAttributes(XModelObject ref, String oldpath, String path) throws XModelException {
        int i = 0;
        while (i < PATH_ATTRIBUTES.length) {
            if (oldpath.equals(ref.getAttributeValue(PATH_ATTRIBUTES[i]))) {
                ref.getModel().changeObjectAttribute(ref, PATH_ATTRIBUTES[i], path);
            }
            ++i;
        }
    }
}

