/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemFactory;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;

public class ItemSet {
    private ISourceViewer viewer;
    private List regions;
    private List directives;
    private List topLevelDirectives;
    private Map directiveRegions;
    private List macroDefinitions = new ArrayList();

    public ItemSet(ISourceViewer viewer, IResource resource) {
        this.viewer = viewer;
        this.regions = new ArrayList();
        int index = 0;
        try {
            while (true) {
                ITypedRegion region = viewer.getDocument().getPartition(index);
                this.regions.add(region);
                index = region.getOffset() + region.getLength() + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            this.parse(viewer, resource);
            return;
        }
    }

    private void parse(ISourceViewer viewer, IResource resource) {
        try {
            this.directives = new ArrayList();
            this.directiveRegions = new HashMap();
            this.topLevelDirectives = new ArrayList();
            Stack<Item> stackDirectives = new Stack<Item>();
            new ArrayList();
            block2: for (ITypedRegion region : this.regions) {
                Item directive = ItemFactory.getItem(region, viewer, resource);
                if (directive == null) continue;
                directive.setItemSet(this);
                if (directive instanceof MacroDirective) {
                    this.macroDefinitions.add(directive);
                }
                if (stackDirectives.size() == 0) {
                    this.topLevelDirectives.add(directive);
                }
                this.directiveRegions.put(new Integer(region.getOffset()), directive);
                if (!directive.isEndItem()) {
                    this.directives.add(directive);
                }
                if (!directive.isStartItem()) {
                    Item directiveCheck = this.getFirstNestableItem(stackDirectives);
                    if (directive.isStartAndEndItem()) {
                        if (directiveCheck != null && directiveCheck.isStartAndEndItem()) {
                            if (directiveCheck.relatesToItem(directive)) {
                                directiveCheck.relateItem(directive);
                                directive.relateItem(directiveCheck);
                            }
                            stackDirectives.pop();
                            directiveCheck = this.getFirstNestableItem(stackDirectives);
                        }
                        if ((directiveCheck = this.getFirstNestableItem(stackDirectives)) != null) {
                            directiveCheck.addSubDirective(directive);
                            directiveCheck.relateItem(directive);
                            directive.relateItem(directiveCheck);
                        }
                        stackDirectives.push(directive);
                        continue;
                    }
                    if (directiveCheck != null && directive.isEndItem() && directiveCheck.isStartAndEndItem()) {
                        if (directiveCheck.relatesToItem(directive)) {
                            directiveCheck.relateItem(directive);
                            directive.relateItem(directiveCheck);
                        }
                        stackDirectives.pop();
                        directiveCheck = this.getFirstNestableItem(stackDirectives);
                    }
                    if (directiveCheck != null && directiveCheck.relatesToItem(directive)) {
                        directiveCheck.relateItem(directive);
                        directive.relateItem(directiveCheck);
                        if (directive.isEndItem()) {
                            Item peek = (Item)stackDirectives.peek();
                            while (peek != null && peek.relatesToItem(directive)) {
                                if (peek.isStartItem()) {
                                    stackDirectives.pop();
                                    continue block2;
                                }
                                stackDirectives.pop();
                                peek = stackDirectives.size() > 0 ? stackDirectives.peek() : null;
                            }
                            continue;
                        }
                        directiveCheck.addSubDirective(directive);
                        stackDirectives.push(directive);
                        continue;
                    }
                    if (!directive.isNestable() && !directive.isEndItem()) {
                        if (directiveCheck == null) continue;
                        directiveCheck.addSubDirective(directive);
                        continue;
                    }
                    if (directive.isNestable() && !directive.isEndItem()) {
                        if (directiveCheck == null) continue;
                        directiveCheck.addSubDirective(directive);
                        stackDirectives.push(directive);
                        continue;
                    }
                    return;
                }
                if (stackDirectives.size() > 0) {
                    ((Item)stackDirectives.peek()).addSubDirective(directive);
                }
                if (!directive.isNestable()) continue;
                stackDirectives.push(directive);
            }
        }
        catch (Exception e) {
            Plugin.log(e);
        }
        Collections.sort(this.macroDefinitions);
    }

    private Item getFirstNestableItem(Stack directives) {
        if (directives.size() == 0) {
            return null;
        }
        Item directiveCheck = null;
        int i = directives.size() - 1;
        while (i >= 0) {
            directiveCheck = (Item)directives.get(i);
            if (directiveCheck.isNestable()) {
                return directiveCheck;
            }
            ++i;
        }
        return null;
    }

    public Item[] getRootItems() {
        return this.topLevelDirectives.toArray(new Item[this.topLevelDirectives.size()]);
    }

    public Item getSelectedItem(int offset) {
        ITypedRegion region = this.getRegion(offset);
        if (region == null) {
            return null;
        }
        return (Item)this.directiveRegions.get(new Integer(region.getOffset()));
    }

    public Item getContextItem(int offset) {
        Item directive = this.getSelectedItem(offset);
        if (directive == null && this.directives != null) {
            Item dt = null;
            for (Item t : this.directives) {
                if (t.isNestable() && t.getRegion().getOffset() < offset) {
                    dt = t;
                    continue;
                }
                if (!t.isEndItem() || t.getRegion().getOffset() >= offset) continue;
                dt = null;
            }
            return dt;
        }
        return directive;
    }

    private ITypedRegion getRegion(int offset) {
        try {
            return this.viewer.getDocument().getPartition(offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public List getMacroDefinitions() {
        return this.macroDefinitions;
    }

    public Item getPreviousItem(int offset) {
        Item item = this.getContextItem(offset);
        if (item == null) {
            for (Item itemSub : this.directives) {
                if (itemSub.getRegion().getOffset() + itemSub.getRegion().getOffset() >= offset) break;
                item = itemSub;
            }
        }
        return item;
    }

    public Item getPreviousStartItem(int offset) {
        Item item = null;
        for (Item itemSub : this.directives) {
            Item itemSub2;
            if (itemSub.getRegion().getOffset() > offset) break;
            if (!itemSub.isStartItem() || (itemSub2 = itemSub.getEndItem()) != null && itemSub2.getRegion().getOffset() <= offset) continue;
            item = itemSub;
        }
        return item;
    }

    public Item getItem(IRegion region) {
        if (this.directiveRegions == null) {
            return null;
        }
        return (Item)this.directiveRegions.get(region);
    }

    public Item getItem(int offset) {
        for (Item item : this.directives) {
            if (item.getRegion().getOffset() > offset || item.getRegion().getOffset() + item.getRegion().getLength() < offset) continue;
            return item;
        }
        return null;
    }
}

