/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.AbstractItem;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ListEndDirective;

public class ListDirective
extends AbstractDirective {
    private ListEndDirective endDirective;

    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }

    public boolean isStartItem() {
        return super.isNestable();
    }

    public void relateItem(Item directive) {
        if (directive instanceof ListEndDirective) {
            this.endDirective = (ListEndDirective)directive;
        }
    }

    public boolean relatesToItem(Item directive) {
        return directive instanceof ListEndDirective;
    }

    public boolean isNestable() {
        return super.isNestable();
    }

    public ListEndDirective getEndDirective() {
        return this.endDirective;
    }

    public Item getRelatedItem() {
        return this.getEndDirective();
    }

    public String getTreeImage() {
        return "list.png";
    }

    public ICompletionProposal[] getCompletionProposals(int offset, Map context) {
        AbstractItem.ContentWithOffset contentWithOffset;
        int index;
        ICompletionProposal[] proposals = super.getCompletionProposals(offset, context);
        if (proposals == null && ((index = (contentWithOffset = this.splitContents(offset)).getIndex()) == 1 || index == 0 && contentWithOffset.wasLastCharSpace())) {
            String value = "";
            if (contentWithOffset.getContents().length >= 2) {
                value = contentWithOffset.getContents()[1];
            }
            CompletionInterpolation completionInterpolation = new CompletionInterpolation("${" + value, offset - contentWithOffset.getOffsetInIndex() - 2, this.getItemSet(), this.getResource());
            proposals = completionInterpolation.getCompletionProposals(offset, context);
        }
        return proposals;
    }

    public void addToContext(Map context) {
        String[] contents = this.splitContents();
        if (contents.length == 4) {
            String key = contents[3];
            CompletionInterpolation completionInterpolation = new CompletionInterpolation("${" + contents[1], 0, this.getItemSet(), this.getResource());
            context.put(key, completionInterpolation.getSingularReturnClass(context));
        }
    }

    public void removeFromContext(Map context) {
        String[] contents = this.splitContents();
        if (contents.length == 4) {
            String key = contents[3];
            context.remove(key);
        }
    }

    public Item getEndItem() {
        return this.endDirective;
    }
}

