/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.command.ToggleShapeExpandStateCommand;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmEditPart;

public class ShapeCollapseAction
extends SelectionAction {
    public static final String ACTION_ID = "shapeCollapseId";
    public static final ImageDescriptor img = ImageDescriptor.createFromFile(DiagramViewer.class, (String)"icons/shapecollapse.png");

    public ShapeCollapseAction(IWorkbenchPart editor) {
        super(editor);
        this.setId(ACTION_ID);
        this.setText(DiagramViewerMessages.ShapeCollapseAction_shape_collapse);
        this.setToolTipText(DiagramViewerMessages.ShapeCollapseAction_shape_collapse_tooltip);
        this.setImageDescriptor(img);
    }

    protected DiagramViewer getDiagramViewer() {
        return (DiagramViewer)this.getWorkbenchPart();
    }

    public void run() {
        this.execute(this.getCommand());
        if (this.getDiagramViewer() != null) {
            this.getDiagramViewer().updateSelectionActions();
        }
    }

    public Command getCommand() {
        CompoundCommand cc = new CompoundCommand();
        if (this.getSelectedObjects().isEmpty()) {
            return cc;
        }
        ArrayList<ExpandableShape> selectedShape = new ArrayList<ExpandableShape>();
        for (Object firstElement : this.getSelectedObjects()) {
            ExpandableShape es;
            Object obj = null;
            if (firstElement instanceof OrmEditPart) {
                obj = ((OrmEditPart)firstElement).getModel();
            } else if (firstElement instanceof AbstractTreeEditPart) {
                obj = ((AbstractTreeEditPart)firstElement).getModel();
            }
            if (obj == null || !(obj instanceof ExpandableShape) || !(es = (ExpandableShape)obj).isExpanded()) continue;
            selectedShape.add(es);
        }
        if (selectedShape.size() > 0) {
            cc.add((Command)new ToggleShapeExpandStateCommand(selectedShape, null));
        }
        return cc;
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    private boolean canPerformAction() {
        boolean res = false;
        if (this.getSelectedObjects().isEmpty()) {
            return res;
        }
        Iterator it = this.getSelectedObjects().iterator();
        while (it.hasNext() && !res) {
            ExpandableShape es;
            Object firstElement = it.next();
            Object obj = null;
            if (firstElement instanceof OrmEditPart) {
                obj = ((OrmEditPart)firstElement).getModel();
            } else if (firstElement instanceof AbstractTreeEditPart) {
                obj = ((AbstractTreeEditPart)firstElement).getModel();
            }
            if (obj == null || !(obj instanceof ExpandableShape) || !(es = (ExpandableShape)obj).isExpanded()) continue;
            res = true;
        }
        return res;
    }
}

