/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.core.resources;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.editor.ModelObjectEditorInput;
import org.jboss.tools.common.model.ui.editor.ModelObjectJarEntryEditorInput;
import org.jboss.tools.common.model.ui.editor.ModelObjectLocationEditorInput;
import org.jboss.tools.common.model.ui.editor.ModelObjectStorageEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class XModelObjectEditorInputFactory
implements IElementFactory {
    private static final String ID_FACTORY = "org.jboss.tools.common.core.resources.XModelObjectEditorInputFactory";
    private static final String TAG_PATH = "path";
    private static final String TAG_PROJECT = "project";
    private static final String TAG_FILE_LOCATION = "filepath";
    private static final String TAG_ENTRY = "entry";

    public IAdaptable createElement(IMemento memento) {
        String projectPath = memento.getString(TAG_PROJECT);
        if (projectPath != null) {
            return this.createStorageElement(memento);
        }
        String fileLocation = memento.getString(TAG_FILE_LOCATION);
        if (fileLocation != null) {
            return this.createStorageElement(memento);
        }
        String fileName = memento.getString(TAG_PATH);
        if (fileName == null) {
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fileName));
        if (res instanceof IFile) {
            XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)res);
            return o != null ? XModelObjectEditorInput.createInstance(o) : new FileEditorInput((IFile)res);
        }
        res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
        return new FileEditorInput((IFile)res);
    }

    private IAdaptable createStorageElement(IMemento memento) {
        String projectPath = memento.getString(TAG_PROJECT);
        XModelObject object = null;
        String missingName = "";
        if (projectPath == null) {
            String fileLocation = memento.getString(TAG_FILE_LOCATION);
            if (fileLocation != null) {
                File f = new File(fileLocation);
                if (f.isFile()) {
                    object = EclipseResourceUtil.createObjectForLocation((String)fileLocation);
                    return object == null ? null : new ModelObjectLocationEditorInput(object, (IPath)new Path(f.getAbsolutePath()));
                }
                missingName = f.getName();
            }
        } else {
            if (memento.getString(TAG_ENTRY) != null) {
                IProject project = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(projectPath));
                String fileLocation = memento.getString(TAG_FILE_LOCATION);
                String entry = memento.getString(TAG_ENTRY);
                return XModelObjectEditorInput.createJarEntryEditorInput(project, fileLocation, entry);
            }
            IProject project = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(projectPath));
            String objectPath = memento.getString(TAG_PATH);
            IModelNature nature = EclipseResourceUtil.getModelNature((IProject)project);
            if (nature == null) {
                missingName = objectPath;
            } else {
                XModel model = nature.getModel();
                object = model.getByPath(objectPath);
            }
        }
        if (object == null) {
            return XModelObjectEditorInputFactory.createNullEditorInput(missingName);
        }
        return new ModelObjectStorageEditorInput(object);
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, IFileEditorInput input) {
        IFile file = input.getFile();
        memento.putString(TAG_PATH, file.getFullPath().toString());
    }

    public static void saveState(IMemento memento, ModelObjectEditorInput input) {
        if (input instanceof ModelObjectJarEntryEditorInput) {
            XModelObjectEditorInputFactory.saveState(memento, (ModelObjectJarEntryEditorInput)input);
            return;
        }
        XModelObject o = input.getXModelObject();
        IProject p = EclipseResourceUtil.getProject((XModelObject)o);
        if (p != null) {
            memento.putString(TAG_PROJECT, p.getFullPath().toString());
            memento.putString(TAG_PATH, o.getPath());
        } else {
            String location = XModelObjectEditorInputFactory.getFileLocation(o);
            if (location != null) {
                memento.putString(TAG_FILE_LOCATION, location);
            }
        }
    }

    public static void saveState(IMemento memento, ModelObjectJarEntryEditorInput input) {
        XModelObject o = input.getXModelObject();
        IProject p = EclipseResourceUtil.getProject((XModelObject)o);
        if (p != null) {
            memento.putString(TAG_PROJECT, p.getFullPath().toString());
            memento.putString(TAG_FILE_LOCATION, input.getJarFile());
            memento.putString(TAG_ENTRY, input.getJarEntry());
        } else {
            String location = XModelObjectEditorInputFactory.getFileLocation(o);
            if (location != null) {
                memento.putString(TAG_FILE_LOCATION, location);
            }
        }
    }

    public static String getFileLocation(XModelObject object) {
        if (object == null || object.getFileType() != 1) {
            return null;
        }
        XModelObject fs = object.getParent();
        while (fs != null && fs.getFileType() != 3) {
            fs = fs.getParent();
        }
        if (fs instanceof FileSystemImpl) {
            FileSystemImpl fsi = (FileSystemImpl)fs;
            String location = String.valueOf(fsi.getAbsoluteLocation()) + XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
            return location;
        }
        return null;
    }

    public static IEditorInput createNullEditorInput(final String entry) {
        return new NullEditorInput(){

            public String getName() {
                int i;
                if (entry != null && (i = entry.lastIndexOf(47)) > 0) {
                    return entry.substring(i + 1);
                }
                return entry;
            }

            public String getToolTipText() {
                return entry;
            }
        };
    }
}

