/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.editor.AbstractSectionEditor;
import org.jboss.tools.common.editor.XModelObjectTreeViewComponent;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectCache;

public class TreeGuiEditor
extends AbstractSectionEditor {
    private SashForm sash = null;
    private XModelObjectTreeViewComponent component;
    private XModelObject xmo = null;
    private XFilteredTreeConstraint[] filters = new XFilteredTreeConstraint[0];

    private void createGui() {
        this.sash = new SashForm(this.guiControl, 256);
        this.control = this.sash;
        this.control.setLayoutData((Object)new GridData(1808));
        this.component = new XModelObjectTreeViewComponent((IEditorPart)this);
        this.component.setModelObject(this.object);
        this.component.setCache(new XModelObjectCache(this.object));
        int i = 0;
        while (i < this.filters.length) {
            this.component.addFilter(this.filters[i]);
            ++i;
        }
        this.component.createControl((Composite)this.sash);
    }

    protected void updateGui() {
        if (this.xmo == this.object) {
            return;
        }
        this.xmo = this.object;
        this.disposeGui();
        this.createGui();
        this.fireGuiModified();
    }

    public TreeViewer getTreeViewer() {
        return this.component == null ? null : this.component.getViewer();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.component == null ? null : this.component.getSelectionProvider();
    }

    public void fireEditorSelected() {
        if (this.getSelectionProvider() != null) {
            this.component.selectionProvider.fireSelectionChanged();
        }
    }

    public void addFilter(XFilteredTreeConstraint filter) {
        this.filters = new XFilteredTreeConstraint[]{filter};
    }

    protected void disposeGui() {
        if (this.component != null) {
            this.component.dispose();
        }
        this.component = null;
        if (this.sash != null && !this.sash.isDisposed()) {
            this.sash.dispose();
        }
        this.sash = null;
        super.disposeGui();
    }
}

