/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeTreeContentProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class CheckListAdapter
extends DefaultValueAdapter {
    public Image IMAGE_ENABLED = EclipseResourceUtil.getImage((String)"images/common/check.gif");
    public Image IMAGE_DISABLED = EclipseResourceUtil.getImage((String)"images/common/uncheck.gif");
    protected ILabelProvider labelProvider;
    protected ITreeContentProvider treeContentProvider;
    private STCPSpecialHelperSupportHandler provider;
    private String[] tags = new String[]{"tag1", "tag2"};

    public CheckListAdapter() {
        this.labelProvider = new STCPTreeLabelProvider();
    }

    public void dispose() {
        super.dispose();
        if (this.treeContentProvider != null) {
            this.treeContentProvider.dispose();
        }
        this.treeContentProvider = null;
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.labelProvider = null;
        if (this.provider != null) {
            this.provider.dispose();
        }
        this.provider = null;
    }

    public void setTags(String[] tags) {
        if (this.provider == null || !(this.provider instanceof STCPSpecialHelperSupportHandler)) {
            this.provider = new STCPSpecialHelperSupportHandler();
        }
        if (!this.differ(this.tags, tags)) {
            return;
        }
        this.tags = tags;
        if (this.provider.viewer != null) {
            this.provider.viewer.refresh();
        }
    }

    public void checkAll() {
        StringBuffer sb = new StringBuffer();
        char separator = this.getSeparator();
        int i = 0;
        while (i < this.tags.length) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(this.tags[i]);
            ++i;
        }
        this.setValue(sb.toString());
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (this.provider != null && this.provider.viewer != null && !this.provider.viewer.getControl().isDisposed()) {
            this.provider.viewer.refresh();
        }
    }

    public String[] getTags() {
        return this.tags;
    }

    private boolean differ(String[] s1, String[] s2) {
        if (s1.length != s2.length) {
            return true;
        }
        int i = 0;
        while (i < s1.length) {
            if (!s1[i].equals(s2[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ITreeContentProvider createTreeContentProvider(XAttribute attribute) {
        return new DefaultXAttributeTreeContentProvider(attribute, this.model, this.modelObject);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ILabelProvider.class) {
            return this.labelProvider;
        }
        if (adapter == ITreeContentProvider.class) {
            if (this.provider != null) {
                return this.provider;
            }
            if (this.treeContentProvider == null) {
                this.treeContentProvider = this.createTreeContentProvider(this.attribute);
            }
            return this.treeContentProvider;
        }
        return super.getAdapter(adapter);
    }

    public char getSeparator() {
        String s;
        XAttribute a = this.getAttribute();
        if (a == null && this.getAttributeData() != null) {
            a = this.getAttributeData().getAttribute();
        }
        if (a != null && "comma".equals(s = a.getProperty("separator"))) {
            return ',';
        }
        return ';';
    }

    class STCPSpecialHelperSupportHandler
    implements ITreeContentProvider {
        Viewer viewer;

        STCPSpecialHelperSupportHandler() {
        }

        public Object[] getElements(Object inputElement) {
            return CheckListAdapter.this.tags;
        }

        public void dispose() {
            this.viewer = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            if (viewer != null) {
                viewer.refresh();
            }
        }

        void ignore() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class STCPTreeLabelProvider
    extends LabelProvider {
        STCPTreeLabelProvider() {
        }
    }
}

