/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.dnd;

import java.util.Properties;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;

public class DnDUtil {
    public static XAction getEnabledAction(XModelObject object, XModelObject[] targets, String actionpath) {
        if (object == null) {
            return null;
        }
        XAction action = object.getModelEntity().getActionList().getAction(actionpath);
        if (action == null) {
            return null;
        }
        return targets == null ? (!action.isEnabled(object) ? null : action) : (!action.isEnabled(object, targets) ? null : action);
    }

    public static boolean isCopyEnabled(XModelObject object, XModelObject[] targets) {
        return DnDUtil.getEnabledCopyAction(object, targets) != null;
    }

    public static XAction getEnabledCopyAction(XModelObject object, XModelObject[] targets) {
        return DnDUtil.getEnabledAction(object, targets, "CopyActions.Copy");
    }

    public static boolean copy(XModelObject object, XModelObject[] targets) {
        XAction copy = DnDUtil.getEnabledCopyAction(object, targets);
        if (copy == null) {
            return false;
        }
        try {
            Properties p = new Properties();
            p.setProperty("isDrag", "true");
            if (targets == null) {
                copy.executeHandler(object, p);
            } else {
                copy.executeHandler(object, targets, p);
            }
            return true;
        }
        catch (XModelException xModelException) {
            return false;
        }
    }

    public static boolean isPasteEnabled(XModelObject object) {
        return DnDUtil.getEnabledPasteAction(object) != null;
    }

    public static XAction getEnabledPasteAction(XModelObject object) {
        XAction action = DnDUtil.getEnabledAction(object, null, "CopyActions.Paste");
        return action != null ? action : DnDUtil.getEnabledAction(object, null, "MoveActions.Move");
    }

    public static void paste(XModelObject object, Properties properties) throws XModelException {
        XAction paste = DnDUtil.getEnabledPasteAction(object);
        if (paste != null) {
            paste.executeHandler(object, properties);
        }
    }
}

