/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.objecteditor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.common.model.ui.objecteditor.XTableImageProvider;
import org.jboss.tools.common.model.ui.objecteditor.XTableProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XTable {
    protected XTableProvider provider;
    protected XTableImageProvider imageProvider;
    protected int style = 68352;
    protected boolean autoResizeColumns = false;
    protected boolean lock = false;
    protected TableViewer tv;
    protected boolean isHeaderVisible = true;
    int[] widths = null;
    private boolean resizeLock = false;

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        this.provider = null;
        if (this.imageProvider != null) {
            this.imageProvider.dispose();
        }
        this.imageProvider = null;
        this.tv = null;
    }

    public void setAutoResize(boolean b) {
        this.autoResizeColumns = b;
    }

    public void setTableProvider(XTableProvider provider) {
        this.provider = provider;
        if (provider instanceof XTableImageProvider) {
            this.imageProvider = (XTableImageProvider)((Object)provider);
        }
    }

    public TableViewer getViewer() {
        return this.tv;
    }

    public void setMultiSelected() {
        this.style |= 2;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, this.style);
    }

    public Control createControl(Composite parent, int style) {
        this.style = style;
        Table table = new Table(parent, style);
        int k = this.provider.getColumnCount();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        int prefferedColumnWidth = 0;
        int i = 0;
        while (i < k) {
            prefferedColumnWidth += this.provider.getWidthHint(i);
            ++i;
        }
        this.widths = new int[k];
        i = 0;
        while (i < k) {
            this.widths[i] = this.provider.getWidthHint(i) * 100 / prefferedColumnWidth;
            ++i;
        }
        int i2 = 0;
        while (i2 < k) {
            TableColumn c = new TableColumn(table, 0);
            c.setText(this.provider.getColumnName(i2));
            ColumnWeightData layoutData = new ColumnWeightData(this.widths[i2], true);
            layout.addColumnData((ColumnLayoutData)layoutData);
            ++i2;
        }
        table.setHeaderVisible(this.isHeaderVisible);
        table.setLinesVisible(true);
        this.tv = new TableViewer(table);
        if (k < 3 || this.autoResizeColumns) {
            table.addControlListener((ControlListener)new Resize(table));
        }
        return table;
    }

    public void updateLayout() {
        if (this.resizeLock) {
            return;
        }
        Table table = this.getTable();
        if (table == null || table.isDisposed()) {
            return;
        }
        this.resizeLock = true;
        try {
            this.updateLayoutInternal(table);
        }
        finally {
            this.resizeLock = false;
        }
    }

    private void updateLayoutInternal(Table table) {
        int k = this.provider.getColumnCount();
        int[] newWidth = new int[k];
        int delta = 0;
        if (table.isVisible()) {
            int w = table.getClientArea().width - 1;
            int cw = 0;
            int hs = 0;
            int i = 0;
            while (i < table.getColumnCount()) {
                cw += table.getColumn(i).getWidth();
                hs += this.getWidthHint(i);
                ++i;
            }
            i = 0;
            while (i < table.getColumnCount()) {
                TableColumn c = table.getColumn(i);
                int dw = (w - cw) * this.getWidthHint(i) / hs;
                newWidth[i] = c.getWidth() + dw;
                delta += Math.abs(dw);
                ++i;
            }
            if (delta < 5) {
                newWidth = this.widths;
            }
        } else {
            newWidth = this.widths;
        }
        int i = 0;
        while (i < k) {
            if (newWidth[i] < 0) {
                return;
            }
            ++i;
        }
        TableLayout layout = new TableLayout();
        int i2 = 0;
        while (i2 < k) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(newWidth[i2], true));
            ++i2;
        }
        this.widths = newWidth;
        table.setLayout((Layout)layout);
        table.layout();
    }

    protected int getWidthHint(int i) {
        return this.widths == null || this.widths.length < 2 || this.widths[i] == 0 ? 10 : this.widths[i];
    }

    public Control getControl() {
        return this.getTable();
    }

    public Table getTable() {
        return this.tv == null ? null : this.tv.getTable();
    }

    public boolean isActive() {
        Table t = this.getTable();
        return t != null && !t.isDisposed();
    }

    public synchronized void update() {
        Table table = this.getTable();
        if (table == null || table.isDisposed()) {
            return;
        }
        int r = table.getSelectionIndex();
        TableItem item = null;
        this.resizeLock = true;
        int i = 0;
        while (i < this.provider.getRowCount()) {
            Color color;
            Object data;
            item = table.getItemCount() > i ? table.getItem(i) : new TableItem(table, 2048, i);
            String[] vs = new String[table.getColumnCount()];
            int j = 0;
            while (j < vs.length) {
                vs[j] = XTable.toVisualValue(this.provider.getValueAt(i, j));
                ++j;
            }
            item.setText(vs);
            if (this.imageProvider != null) {
                item.setImage(this.imageProvider.getImage(i));
            }
            if ((data = this.provider.getDataAt(i)) != null) {
                item.setData(data);
            }
            if ((color = this.provider.getColor(i)) != null) {
                item.setForeground(color);
            }
            ++i;
        }
        if (table.getTopIndex() > this.provider.getRowCount()) {
            int ti = this.provider.getRowCount() - 20;
            if (ti < 0) {
                ti = 0;
            }
            table.setTopIndex(ti);
        }
        table.remove(this.provider.getRowCount(), table.getItemCount() - 1);
        if (r >= 0) {
            try {
                table.setSelection(r);
            }
            catch (SWTException sWTException) {}
        }
        this.resizeLock = false;
    }

    public static String toVisualValue(String v) {
        if (v == null) {
            return "";
        }
        if (v.indexOf(10) >= 0) {
            v = v.replace('\n', ' ');
        }
        if (v.indexOf(9) >= 0) {
            v = v.replace('\t', ' ');
        }
        if (v.indexOf(13) >= 0) {
            v = v.replace('\r', ' ');
        }
        return v;
    }

    public int getSelectionIndex() {
        return this.getTable().getSelectionIndex();
    }

    public void setSelection(int i) {
        this.getTable().setSelection(i);
    }

    protected Set<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        Table table = this.getTable();
        int c = table == null || table.isDisposed() ? 0 : table.getItemCount();
        int i = 0;
        while (i < c) {
            set.add(this.getTable().getItem(i).getText(0));
            ++i;
        }
        return set;
    }

    protected int getAddedKey(Set set) {
        Table table = this.getTable();
        if (table == null || table.isDisposed()) {
            return -1;
        }
        int c = table.getItemCount();
        int i = 0;
        while (i < c) {
            if (!set.contains(this.getTable().getItem(i).getText(0))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setHeaderVisible(boolean b) {
        if (this.isHeaderVisible == b) {
            return;
        }
        this.isHeaderVisible = b;
        if (this.isActive()) {
            this.getTable().setHeaderVisible(this.isHeaderVisible);
        }
    }

    class Resize
    extends ControlAdapter {
        Resize(Table table) {
            table.addControlListener((ControlListener)this);
        }

        public void controlResized(ControlEvent e) {
            this.updateColumnWidth();
        }

        private void updateColumnWidth() {
            XTable.this.updateLayout();
        }
    }
}

