/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizard.newfile;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class NewFileContext {
    protected IResource resource;
    protected XModelObject folder;
    protected XModelObject fakeFolder;
    protected XAction action;
    protected SpecialWizardSupport support = this.createSupport();
    protected String errorMesage = null;
    protected String helpkey;
    static String COMPANY_NAME = "Red Hat";

    public void init() {
        XModel model = ModelUtilities.getPreferenceModel();
        this.fakeFolder = model.createModelObject("FileFolder", null);
        XActionList list = model.getMetaData().getEntity("FileFolder").getActionList();
        this.action = list.getAction(this.getActionPath());
        this.support.setActionData(this.action, this.action.getEntityData(this.fakeFolder), this.fakeFolder, null);
        this.helpkey = "FileFolder_" + this.action.getName();
    }

    protected SpecialWizardSupport createSupport() {
        return new SWS();
    }

    protected String getActionPath() {
        return null;
    }

    public void setSelection(IStructuredSelection selection) {
        this.errorMesage = null;
        this.resource = null;
        this.folder = null;
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IResource) {
            this.resource = (IResource)o;
        } else if (o instanceof IAdaptable) {
            this.resource = (IResource)((IAdaptable)o).getAdapter(IResource.class);
        }
        if (this.resource != null && !this.resource.getProject().isOpen()) {
            this.errorMesage = "Project is closed";
            return;
        }
        if (EclipseResourceUtil.getModelNature((IProject)this.resource.getProject()) == null) {
            this.errorMesage = "Add Struts Nature to project";
        }
        this.folder = EclipseResourceUtil.getObjectByResource((IResource)this.resource);
        if (this.folder != null && this.folder.getFileType() <= 1) {
            if (this.folder.getFileType() == 0) {
                this.folder = this.folder.getModel().getByPath("FileSystems/WEB-INF");
            } else if (this.folder.getFileType() == 1) {
                this.folder = this.folder.getParent();
            }
        }
        if (!(this.folder instanceof FolderImpl)) {
            this.folder = null;
        }
        if (this.folder == null) {
            this.errorMesage = "Cannot find " + COMPANY_NAME + " model element for resource " + this.resource.getLocation().toString();
        } else {
            this.support.setActionData(this.action, this.action.getEntityData(this.folder), this.folder, null);
        }
    }

    public String validate(Properties data) {
        if (this.errorMesage != null) {
            return this.errorMesage;
        }
        this.support.getValidator(0).validate(data);
        return this.support.getValidator(0).getErrorMessage();
    }

    public void execute() throws XModelException {
        Properties p = new Properties();
        if (this.resource != null) {
            p.put("resource", this.resource);
        }
        this.action.executeHandler(this.support.getTarget(), p);
    }

    public boolean update() {
        if (this.folder == null) {
            return false;
        }
        this.action.getEntityData(this.folder);
        return true;
    }

    public XModelObject getFakeObject() {
        return this.fakeFolder;
    }

    public SpecialWizardSupport getSupport() {
        return this.support;
    }

    public String getWindowTitle() {
        String title = WizardKeys.getHeader((String)this.helpkey);
        return title == null ? "" : title;
    }

    public String getTitle() {
        String title = WizardKeys.getTitle((String)this.helpkey);
        return title == null ? "" : title;
    }

    class SWS
    extends SpecialWizardSupport {
        public void action(String name) throws XModelException {
        }
    }
}

