/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class DeleteMarkersCommand
extends AbstractDefaultCommand {
    private static final long serialVersionUID = 1L;
    private IMarker[] marker;

    public DeleteMarkersCommand() {
        this.setDescription("Deletes a possible high number of markers");
        this.setName("DeleteMarkersCommand");
        this.setOutputProperties(true);
        this.setReadOnly(false);
        this.setTerminated(false);
        this.setMarkers(null);
        this.setUserInitiated(false);
    }

    public final void setMarkers(IMarker[] iMarkerArray) {
        this.marker = iMarkerArray;
    }

    public boolean isReadyToExecute() {
        return this.marker != null;
    }

    public void execute() throws CommandException {
        try {
            this.beginTask("Deleting single markers", this.marker.length);
            int n = 0;
            while (n < this.marker.length && !this.isCanceled()) {
                this.marker[n].delete();
                this.worked(1);
                ++n;
            }
        }
        catch (CoreException coreException) {
            throw new CommandException(coreException);
        }
    }

    public void reset() {
        this.setMarkers(null);
    }
}

