/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.CPDVisitor;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;

public class DetectCutAndPasteCmd
extends AbstractDefaultCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger log;
    private IProject project;
    private Language language;
    private int minTileSize;
    private Renderer renderer;
    private String reportName;
    private boolean createReport;
    private List listenerList;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.DetectCutAndPasteCmd");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public DetectCutAndPasteCmd() {
        this.setDescription("Detect Cut & paste for a project");
        this.setName("DetectCutAndPaste");
        this.setOutputProperties(true);
        this.setReadOnly(false);
        this.setTerminated(false);
        this.listenerList = new ArrayList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws CommandException {
        try {
            try {
                List list = this.findFiles();
                if (list.size() == 0) {
                    PMDPlugin.getDefault().logInformation("No files found to specified language.");
                } else {
                    PMDPlugin.getDefault().logInformation("Found " + list.size() + " files to the specified language. Performing CPD.");
                }
                this.setStepsCount(list.size());
                this.beginTask("Finding suspect Cut And Paste", this.getStepsCount() * 2);
                if (!this.isCanceled()) {
                    final CPD cPD = this.detectCutAndPaste(list);
                    if (!this.isCanceled()) {
                        if (this.createReport) {
                            this.renderReport(cPD.getMatches());
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                Iterator iterator = DetectCutAndPasteCmd.this.listenerList.iterator();
                                while (iterator.hasNext()) {
                                    IPropertyListener iPropertyListener = (IPropertyListener)iterator.next();
                                    iPropertyListener.propertyChanged((Object)cPD.getMatches(), 1111);
                                }
                            }
                        });
                    }
                }
            }
            catch (CoreException coreException) {
                log.debug((Object)("Core Exception: " + coreException.getMessage()), (Throwable)coreException);
                throw new CommandException(coreException);
            }
            catch (PropertiesException propertiesException) {
                log.debug((Object)("Properties Exception: " + propertiesException.getMessage()), (Throwable)propertiesException);
                throw new CommandException(propertiesException);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.setTerminated(true);
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        this.setTerminated(true);
    }

    public void reset() {
        this.setProject(null);
        this.setTerminated(false);
        this.setReportName(null);
        this.setRenderer(null);
        this.setLanguage("java");
        this.setMinTileSize(PMDPlugin.getDefault().loadPreferences().getMinTileSize());
        this.setCreateReport(false);
        this.addPropertyListener(null);
        this.listenerList = new ArrayList();
    }

    public void setLanguage(String string) {
        this.language = new LanguageFactory().createLanguage(string);
    }

    public void setMinTileSize(int n) {
        this.minTileSize = n;
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public void setReportName(String string) {
        this.reportName = string;
    }

    public void setCreateReport(boolean bl) {
        this.createReport = bl;
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.listenerList.add(iPropertyListener);
    }

    public boolean isReadyToExecute() {
        return this.project != null && this.language != null && (!this.createReport || this.renderer != null && this.reportName != null);
    }

    private List findFiles() throws PropertiesException, CoreException {
        IProjectProperties iProjectProperties = PMDPlugin.getDefault().loadProjectProperties(this.project);
        CPDVisitor cPDVisitor = new CPDVisitor();
        cPDVisitor.setWorkingSet(iProjectProperties.getProjectWorkingSet());
        cPDVisitor.setIncludeDerivedFiles(iProjectProperties.isIncludeDerivedFiles());
        cPDVisitor.setLanguage(this.language);
        cPDVisitor.setFiles(new ArrayList());
        this.project.accept((IResourceVisitor)cPDVisitor);
        return cPDVisitor.getFiles();
    }

    private CPD detectCutAndPaste(List list) {
        log.debug((Object)"Searching for project files");
        CPD cPD = new CPD(this.minTileSize, this.language);
        this.subTask("Adding files for the CPD");
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !this.isCanceled()) {
            File file = (File)iterator.next();
            try {
                cPD.add(file);
                this.worked(1);
            }
            catch (IOException iOException) {
                log.warn((Object)("IOException when adding file " + file.getName() + " to CPD. Continuing."), (Throwable)iOException);
            }
        }
        if (!this.isCanceled()) {
            this.subTask("Performing CPD");
            log.debug((Object)"Performing CPD");
            cPD.go();
            this.worked(this.getStepsCount());
        }
        return cPD;
    }

    private void renderReport(Iterator iterator) throws CommandException {
        try {
            log.debug((Object)"Rendering CPD report");
            this.subTask("Rendering CPD report");
            String string = this.renderer.render(iterator);
            log.debug((Object)"Create the report folder");
            IFolder iFolder = this.project.getFolder("reports");
            if (!iFolder.exists()) {
                iFolder.create(true, true, this.getMonitor());
            }
            log.debug((Object)"Create the report file");
            IFile iFile = iFolder.getFile(this.reportName);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            if (iFile.exists()) {
                log.debug((Object)"   Overwritting the report file");
                iFile.setContents((InputStream)byteArrayInputStream, true, false, this.getMonitor());
            } else {
                log.debug((Object)"   Creating the report file");
                iFile.create((InputStream)byteArrayInputStream, true, this.getMonitor());
            }
            iFile.refreshLocal(2, this.getMonitor());
            ((InputStream)byteArrayInputStream).close();
        }
        catch (CoreException coreException) {
            log.debug((Object)("Core Exception: " + coreException.getMessage()), (Throwable)coreException);
            throw new CommandException(coreException);
        }
        catch (IOException iOException) {
            log.debug((Object)("IO Exception: " + iOException.getMessage()), (Throwable)iOException);
            throw new CommandException(iOException);
        }
    }
}

