/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaProjectClassLoader
extends URLClassLoader {
    private static final Logger log;
    private Set javaProjects = new HashSet();
    private IWorkspaceRoot workspaceRoot;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.JavaProjectClassLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public JavaProjectClassLoader(ClassLoader classLoader, IJavaProject iJavaProject) {
        super(new URL[0], classLoader);
        this.workspaceRoot = iJavaProject.getProject().getWorkspace().getRoot();
        this.addURLs(iJavaProject, false);
        this.javaProjects = null;
        this.workspaceRoot = null;
    }

    private void addURLs(IJavaProject iJavaProject, boolean bl) {
        if (!this.javaProjects.contains(iJavaProject)) {
            this.javaProjects.add(iJavaProject);
            try {
                this.addURL(iJavaProject.getOutputLocation());
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
                int n = 0;
                while (n < iClasspathEntryArray.length) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                    if (iClasspathEntry.isExported() || !bl) {
                        switch (iClasspathEntry.getEntryKind()) {
                            case 2: {
                                IProject iProject = iJavaProject.getProject().getWorkspace().getRoot().getProject(iClasspathEntry.getPath().toString());
                                IJavaProject iJavaProject2 = JavaCore.create((IProject)iProject);
                                if (iJavaProject2 == null) break;
                                this.addURLs(iJavaProject2, true);
                                break;
                            }
                            case 1: {
                                this.addURL(iClasspathEntry);
                                break;
                            }
                            case 3: {
                                IPath iPath = iClasspathEntry.getOutputLocation();
                                if (iPath == null) break;
                                this.addURL(iPath);
                                break;
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {
                log.debug((Object)("MalformedURLException occurred: " + javaModelException.getLocalizedMessage()), (Throwable)javaModelException);
            }
        }
    }

    private void addURL(IClasspathEntry iClasspathEntry) {
        this.addURL(iClasspathEntry.getPath());
    }

    private void addURL(IPath iPath) {
        try {
            if (this.workspaceRoot.exists(iPath)) {
                iPath = this.workspaceRoot.getLocation().append(iPath);
            }
            URL uRL = iPath.toFile().getAbsoluteFile().toURI().toURL();
            this.addURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            log.debug((Object)("MalformedURLException occurred: " + malformedURLException.getLocalizedMessage()), (Throwable)malformedURLException);
        }
    }
}

