/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import name.herlin.command.CommandException;
import name.herlin.command.Timer;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.DeltaVisitor;
import net.sourceforge.pmd.eclipse.runtime.cmd.MarkerInfo;
import net.sourceforge.pmd.eclipse.runtime.cmd.ResourceVisitor;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReviewCodeCmd
extends AbstractDefaultCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger log;
    private final List resources = new ArrayList();
    private IResourceDelta resourceDelta;
    private Map markers = new HashMap();
    private boolean taskMarker = false;
    private boolean openPmdPerspective = false;
    private int rulesCount;
    private int filesCount;
    private long pmdDuration;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public ReviewCodeCmd() {
        this.setDescription("Run PMD on a list of workbench resources.");
        this.setName("ReviewCode");
        this.setOutputProperties(true);
        this.setReadOnly(true);
        this.setTerminated(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws CommandException {
        log.info((Object)"ReviewCode command starting.");
        try {
            try {
                this.filesCount = 0;
                this.rulesCount = 0;
                this.pmdDuration = 0L;
                if (this.resources.size() == 0) {
                    this.beginTask("PMD Checking...", this.getStepsCount());
                    this.processResourceDelta();
                } else {
                    this.beginTask("PMD Checking...", this.getStepsCount());
                    this.processResources();
                }
                IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                        ReviewCodeCmd.this.applyMarkers();
                    }
                };
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                iWorkspace.run(iWorkspaceRunnable, this.getschedulingRule(), 1, this.getMonitor());
                if (this.openPmdPerspective) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ReviewCodeCmd.this.switchToPmdPerspective();
                        }
                    });
                }
            }
            catch (CoreException coreException) {
                throw new CommandException("Core exception when reviewing code", coreException);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            log.info((Object)"ReviewCode command has ended.");
            this.setTerminated(true);
            this.done();
            if (this.filesCount > 0 && this.rulesCount > 0) {
                PMDPlugin.getDefault().logInformation("Review code command terminated. " + this.rulesCount + " rules were executed against " + this.filesCount + " files. Actual PMD duration is about " + this.pmdDuration + "ms, that is about " + (float)this.pmdDuration / (float)this.filesCount + " ms/file, " + (float)this.pmdDuration / (float)this.rulesCount + " ms/rule, " + (float)this.pmdDuration / (float)((long)this.filesCount * (long)this.rulesCount) + " ms/filerule");
                throw throwable;
            }
            PMDPlugin.getDefault().logInformation("Review code command terminated. " + this.rulesCount + " rules were executed against " + this.filesCount + " files. PMD was not executed.");
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        log.info((Object)"ReviewCode command has ended.");
        this.setTerminated(true);
        this.done();
        if (this.filesCount > 0 && this.rulesCount > 0) {
            PMDPlugin.getDefault().logInformation("Review code command terminated. " + this.rulesCount + " rules were executed against " + this.filesCount + " files. Actual PMD duration is about " + this.pmdDuration + "ms, that is about " + (float)this.pmdDuration / (float)this.filesCount + " ms/file, " + (float)this.pmdDuration / (float)this.rulesCount + " ms/rule, " + (float)this.pmdDuration / (float)((long)this.filesCount * (long)this.rulesCount) + " ms/filerule");
            return;
        }
        PMDPlugin.getDefault().logInformation("Review code command terminated. " + this.rulesCount + " rules were executed against " + this.filesCount + " files. PMD was not executed.");
    }

    public Map getMarkers() {
        return this.markers;
    }

    public void setResources(List list) {
        this.resources.clear();
        this.resources.addAll(list);
    }

    public void addResource(IResource iResource) {
        if (iResource == null) {
            throw new IllegalArgumentException("Resource parameter can not be null");
        }
        this.resources.add(iResource);
    }

    public void setResourceDelta(IResourceDelta iResourceDelta) {
        this.resourceDelta = iResourceDelta;
    }

    public void setTaskMarker(boolean bl) {
        this.taskMarker = bl;
    }

    public void setOpenPmdPerspective(boolean bl) {
        this.openPmdPerspective = bl;
    }

    public void reset() {
        this.resources.clear();
        this.markers = new HashMap();
        this.setTerminated(false);
        this.openPmdPerspective = false;
    }

    public boolean isReadyToExecute() {
        return this.resources.size() != 0 || this.resourceDelta != null;
    }

    private ISchedulingRule getschedulingRule() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IResourceRuleFactory iResourceRuleFactory = iWorkspace.getRuleFactory();
        ISchedulingRule iSchedulingRule = null;
        if (this.resources.size() == 0) {
            iSchedulingRule = iResourceRuleFactory.markerRule((IResource)this.resourceDelta.getResource().getProject());
        } else {
            ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[this.resources.size()];
            int n = 0;
            while (n < iSchedulingRuleArray.length) {
                iSchedulingRuleArray[n] = iResourceRuleFactory.markerRule((IResource)this.resources.get(n));
                ++n;
            }
            iSchedulingRule = new MultiRule(this.resources.toArray(iSchedulingRuleArray));
        }
        return iSchedulingRule;
    }

    private void processResources() throws CommandException {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (iResource instanceof IProject) {
                this.processProject((IProject)iResource);
                continue;
            }
            this.processResource(iResource);
        }
    }

    private void processResource(IResource iResource) throws CommandException {
        try {
            IProject iProject = iResource.getProject();
            IProjectProperties iProjectProperties = PMDPlugin.getDefault().loadProjectProperties(iProject);
            RuleSet ruleSet = iProjectProperties.getProjectRuleSet();
            PMD pMD = this.getPmdEngineForProject(iProject);
            this.setStepsCount(this.countResourceElement(iResource));
            log.debug((Object)("Visiting resource " + iResource.getName() + " : " + this.getStepsCount()));
            ResourceVisitor resourceVisitor = new ResourceVisitor();
            resourceVisitor.setMonitor(this.getMonitor());
            resourceVisitor.setRuleSet(ruleSet);
            resourceVisitor.setPmdEngine(pMD);
            resourceVisitor.setAccumulator(this.markers);
            resourceVisitor.setUseTaskMarker(this.taskMarker);
            resourceVisitor.setProjectProperties(iProjectProperties);
            iResource.accept((IResourceVisitor)resourceVisitor);
            this.rulesCount = ruleSet.getRules().size();
            this.filesCount += resourceVisitor.getProcessedFilesCount();
            this.pmdDuration += resourceVisitor.getActualPmdDuration();
        }
        catch (PropertiesException propertiesException) {
            throw new CommandException(propertiesException);
        }
        catch (CoreException coreException) {
            throw new CommandException(coreException);
        }
    }

    private void processProject(IProject iProject) throws CommandException {
        try {
            if (!iProject.hasNature("org.eclipse.jdt.core.javanature")) {
                log.debug((Object)("Skipping non-Java natured project " + iProject.getName()));
                return;
            }
            this.setStepsCount(this.countResourceElement((IResource)iProject));
            log.debug((Object)("Visiting  project " + iProject.getName() + " : " + this.getStepsCount()));
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                if (iClasspathEntryArray[n].getEntryKind() == 3) {
                    IFolder iFolder = null;
                    try {
                        iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(iClasspathEntryArray[n].getPath());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        iFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(iClasspathEntryArray[n].getPath().toString());
                    }
                    if (iFolder == null) {
                        log.warn((Object)("Source container " + iClasspathEntryArray[n].getPath() + " for project " + iProject.getName() + " is not valid"));
                    } else {
                        this.processResource((IResource)iFolder);
                    }
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            throw new CommandException(coreException);
        }
    }

    private void processResourceDelta() throws CommandException {
        try {
            IProject iProject = this.resourceDelta.getResource().getProject();
            IProjectProperties iProjectProperties = PMDPlugin.getDefault().loadProjectProperties(iProject);
            RuleSet ruleSet = iProjectProperties.getProjectRuleSet();
            PMD pMD = this.getPmdEngineForProject(iProject);
            this.setStepsCount(this.countDeltaElement(this.resourceDelta));
            log.debug((Object)("Visit of resource delta : " + this.getStepsCount()));
            DeltaVisitor deltaVisitor = new DeltaVisitor();
            deltaVisitor.setMonitor(this.getMonitor());
            deltaVisitor.setRuleSet(ruleSet);
            deltaVisitor.setPmdEngine(pMD);
            deltaVisitor.setAccumulator(this.markers);
            deltaVisitor.setUseTaskMarker(this.taskMarker);
            deltaVisitor.setProjectProperties(iProjectProperties);
            this.resourceDelta.accept((IResourceDeltaVisitor)deltaVisitor);
            this.rulesCount = ruleSet.getRules().size();
            this.filesCount += deltaVisitor.getProcessedFilesCount();
            this.pmdDuration += deltaVisitor.getActualPmdDuration();
        }
        catch (PropertiesException propertiesException) {
            throw new CommandException(propertiesException);
        }
        catch (CoreException coreException) {
            throw new CommandException(coreException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyMarkers() {
        log.info((Object)"Processing marker directives");
        int n = 0;
        Timer timer = new Timer();
        String string = "";
        try {
            try {
                Set set = this.markers.keySet();
                Iterator iterator = set.iterator();
                this.beginTask("PMD Applying markers", set.size());
                block5: while (iterator.hasNext() && !this.isCanceled()) {
                    IFile iFile = (IFile)iterator.next();
                    string = iFile.getName();
                    Set set2 = (Set)this.markers.get(iFile);
                    iFile.deleteMarkers("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true, 2);
                    iFile.deleteMarkers("net.sourceforge.pmd.eclipse.plugin.pmdDFAMarker", true, 2);
                    Iterator iterator2 = set2.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            this.worked(1);
                            continue block5;
                        }
                        MarkerInfo markerInfo = (MarkerInfo)iterator2.next();
                        IMarker iMarker = iFile.createMarker(markerInfo.getType());
                        iMarker.setAttributes(markerInfo.getAttributeNames(), markerInfo.getAttributeValues());
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                log.warn((Object)("CoreException when setting marker info for file " + string + " : " + coreException.getMessage()));
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            timer.stop();
            PMDPlugin.getDefault().logInformation(n + " markers applied on " + this.markers.size() + " files in " + timer.getDuration() + "ms.");
            log.info((Object)("End of processing marker directives. " + n + " violations for " + this.markers.size() + " files."));
            throw throwable;
        }
        {
            Object var11_14 = null;
            timer.stop();
            PMDPlugin.getDefault().logInformation(n + " markers applied on " + this.markers.size() + " files in " + timer.getDuration() + "ms.");
        }
        log.info((Object)("End of processing marker directives. " + n + " violations for " + this.markers.size() + " files."));
    }

    private int countResourceElement(IResource iResource) {
        CountVisitor countVisitor = new CountVisitor();
        try {
            iResource.accept((IResourceVisitor)countVisitor);
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("Exception when counting elements of a project", coreException);
        }
        return countVisitor.count;
    }

    private int countDeltaElement(IResourceDelta iResourceDelta) {
        CountVisitor countVisitor = new CountVisitor();
        try {
            iResourceDelta.accept((IResourceDeltaVisitor)countVisitor);
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("Exception counting elemnts in a delta selection", coreException);
        }
        return countVisitor.count;
    }

    private void switchToPmdPerspective() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IPerspectiveRegistry iPerspectiveRegistry = iWorkbench.getPerspectiveRegistry();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        iWorkbenchWindow.getActivePage().setPerspective(iPerspectiveRegistry.findPerspectiveWithId("net.sourceforge.pmd.eclipse.ui.views.pmdPerspective"));
    }

    private final class CountVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        public int count = 0;

        private CountVisitor() {
        }

        public boolean visit(IResource iResource) {
            boolean bl = true;
            ++this.count;
            if (iResource instanceof IFile && ((IFile)iResource).getFileExtension() != null && ((IFile)iResource).getFileExtension().equals("java")) {
                bl = false;
            }
            return bl;
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            ++this.count;
            return true;
        }
    }
}

